/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml.implementation;

import com.azure.xml.XmlReader;
import com.azure.xml.XmlToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class DefaultXmlReader
extends XmlReader {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newFactory();
    private final XMLStreamReader reader;
    private XmlToken currentToken;

    public static XmlReader fromBytes(byte[] xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return DefaultXmlReader.fromStream(new ByteArrayInputStream(xml));
    }

    public static XmlReader fromString(String xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return DefaultXmlReader.fromReader(new StringReader(xml));
    }

    public static XmlReader fromStream(InputStream xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return new DefaultXmlReader(XML_INPUT_FACTORY.createXMLStreamReader(xml));
    }

    public static XmlReader fromReader(Reader xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return new DefaultXmlReader(XML_INPUT_FACTORY.createXMLStreamReader(xml));
    }

    private DefaultXmlReader(XMLStreamReader reader) {
        this.reader = reader;
        this.currentToken = DefaultXmlReader.convertEventToToken(reader.getEventType());
    }

    @Override
    public XmlToken currentToken() {
        return this.currentToken;
    }

    @Override
    public XmlToken nextElement() throws XMLStreamException {
        int next = this.reader.next();
        while (next != 1 && next != 2 && next != 8) {
            next = this.reader.next();
        }
        this.currentToken = DefaultXmlReader.convertEventToToken(next);
        return this.currentToken;
    }

    @Override
    public QName getElementName() {
        return this.reader.getName();
    }

    @Override
    public String getStringElement() throws XMLStreamException {
        int readCount = 0;
        String firstRead = null;
        String[] buffer = null;
        int stringBufferSize = 0;
        int nextEvent = this.reader.next();
        while (nextEvent != 2) {
            if (nextEvent == 4 || nextEvent == 12 || nextEvent == 6 || nextEvent == 9) {
                if (++readCount == 1) {
                    firstRead = this.reader.getText();
                    stringBufferSize = firstRead.length();
                } else {
                    String readText;
                    if (readCount == 2) {
                        buffer = new String[4];
                        buffer[0] = firstRead;
                    }
                    if (readCount > buffer.length - 1) {
                        String[] newBuffer = new String[buffer.length * 2];
                        System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                        buffer = newBuffer;
                    }
                    buffer[readCount - 1] = readText = this.reader.getText();
                    stringBufferSize += readText.length();
                }
            } else if (nextEvent != 3 && nextEvent != 5) {
                throw new XMLStreamException("Unexpected event type while reading element value " + nextEvent);
            }
            nextEvent = this.reader.next();
        }
        if (readCount == 0) {
            return null;
        }
        if (readCount == 1) {
            return firstRead;
        }
        StringBuilder finalText = new StringBuilder(stringBufferSize);
        for (String str : buffer) {
            finalText.append(str);
        }
        return finalText.toString();
    }

    @Override
    public String getStringAttribute(String namespaceUri, String localName) {
        String value = this.reader.getAttributeValue(namespaceUri, localName);
        return "".equals(value) ? null : value;
    }

    @Override
    public void close() throws XMLStreamException {
        this.reader.close();
    }

    private static XmlToken convertEventToToken(int event) {
        switch (event) {
            case 1: {
                return XmlToken.START_ELEMENT;
            }
            case 2: {
                return XmlToken.END_ELEMENT;
            }
            case 7: {
                return XmlToken.START_DOCUMENT;
            }
            case 8: {
                return XmlToken.END_DOCUMENT;
            }
        }
        throw new IllegalStateException("Unknown/unsupported XMLStreamConstants: " + event);
    }

    static {
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.supportDTD", false);
    }
}

