/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml;

import com.azure.xml.ReadValueCallback;
import com.azure.xml.XmlToken;
import java.io.IOException;
import java.util.Base64;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public abstract class XmlReader
implements AutoCloseable {
    public abstract XmlToken currentToken();

    public abstract XmlToken nextElement() throws XMLStreamException;

    @Override
    public abstract void close() throws XMLStreamException;

    public abstract QName getElementName();

    public abstract String getStringAttribute(String var1, String var2);

    public final byte[] getBinaryAttribute(String namespaceUri, String localName) {
        String value = this.getStringAttribute(namespaceUri, localName);
        return value == null || value.isEmpty() ? null : Base64.getDecoder().decode(value);
    }

    public final boolean getBooleanAttribute(String namespaceUri, String localName) {
        return Boolean.parseBoolean(this.getStringAttribute(namespaceUri, localName));
    }

    public final double getDoubleAttribute(String namespaceUri, String localName) {
        return Double.parseDouble(this.getStringAttribute(namespaceUri, localName));
    }

    public final float getFloatAttribute(String namespaceUri, String localName) {
        return Float.parseFloat(this.getStringAttribute(namespaceUri, localName));
    }

    public final int getIntAttribute(String namespaceUri, String localName) {
        return Integer.parseInt(this.getStringAttribute(namespaceUri, localName));
    }

    public final long getLongAttribute(String namespaceUri, String localName) {
        return Long.parseLong(this.getStringAttribute(namespaceUri, localName));
    }

    public final <T> T getNullableAttribute(String namespaceUri, String localName, ReadValueCallback<String, T> converter) throws XMLStreamException {
        String textValue = this.getStringAttribute(namespaceUri, localName);
        if (textValue == null) {
            return null;
        }
        try {
            return converter.read(textValue);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public abstract String getStringElement() throws XMLStreamException;

    public final byte[] getBinaryElement() throws XMLStreamException {
        String value = this.getStringElement();
        return value == null || value.isEmpty() ? null : Base64.getDecoder().decode(value);
    }

    public final boolean getBooleanElement() throws XMLStreamException {
        return Boolean.parseBoolean(this.getStringElement());
    }

    public final double getDoubleElement() throws XMLStreamException {
        return Double.parseDouble(this.getStringElement());
    }

    public final float getFloatElement() throws XMLStreamException {
        return Float.parseFloat(this.getStringElement());
    }

    public final int getIntElement() throws XMLStreamException {
        return Integer.parseInt(this.getStringElement());
    }

    public final long getLongElement() throws XMLStreamException {
        return Long.parseLong(this.getStringElement());
    }

    public final <T> T getNullableElement(ReadValueCallback<String, T> converter) throws XMLStreamException {
        String textValue = this.getStringElement();
        if (textValue == null) {
            return null;
        }
        try {
            return converter.read(textValue);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public final <T> T readObject(String localName, ReadValueCallback<XmlReader, T> converter) throws XMLStreamException {
        return this.readObject(null, localName, converter);
    }

    public final <T> T readObject(String namespaceUri, String localName, ReadValueCallback<XmlReader, T> converter) throws XMLStreamException {
        return this.readObject(new QName(namespaceUri, localName), converter);
    }

    private <T> T readObject(QName startTagName, ReadValueCallback<XmlReader, T> converter) throws XMLStreamException {
        if (this.currentToken() != XmlToken.START_ELEMENT) {
            this.nextElement();
        }
        if (this.currentToken() != XmlToken.START_ELEMENT) {
            throw new IllegalStateException("Illegal start of XML deserialization. Expected 'XmlToken.START_ELEMENT' but it was: 'XmlToken." + (Object)((Object)this.currentToken()) + "'.");
        }
        QName tagName = this.getElementName();
        if (!Objects.equals(startTagName, tagName)) {
            throw new IllegalStateException("Expected XML element to be '" + startTagName + "' but it was: " + tagName + "'.");
        }
        try {
            return converter.read(this);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public final void skipElement() throws XMLStreamException {
        XmlToken currentToken = this.currentToken();
        if (currentToken != XmlToken.START_ELEMENT) {
            return;
        }
        int depth = 1;
        while (depth > 0) {
            currentToken = this.nextElement();
            if (currentToken == XmlToken.START_ELEMENT) {
                ++depth;
                continue;
            }
            if (currentToken != XmlToken.END_ELEMENT) break;
            --depth;
        }
    }
}

