/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

public final class MessageIdsUpdateHeaders {
    private String xMsVersion;
    private DateTimeRfc1123 xMsTimeNextVisible;
    private String xMsRequestId;
    private String xMsPopreceipt;
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_TIME_NEXT_VISIBLE = HttpHeaderName.fromString((String)"x-ms-time-next-visible");
    private static final HttpHeaderName X_MS_POPRECEIPT = HttpHeaderName.fromString((String)"x-ms-popreceipt");

    public MessageIdsUpdateHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsTimeNextVisible = rawHeaders.getValue(X_MS_TIME_NEXT_VISIBLE);
        this.xMsTimeNextVisible = xMsTimeNextVisible != null ? new DateTimeRfc1123(xMsTimeNextVisible) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.xMsPopreceipt = rawHeaders.getValue(X_MS_POPRECEIPT);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public MessageIdsUpdateHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public OffsetDateTime getXMsTimeNextVisible() {
        if (this.xMsTimeNextVisible == null) {
            return null;
        }
        return this.xMsTimeNextVisible.getDateTime();
    }

    public MessageIdsUpdateHeaders setXMsTimeNextVisible(OffsetDateTime xMsTimeNextVisible) {
        this.xMsTimeNextVisible = xMsTimeNextVisible == null ? null : new DateTimeRfc1123(xMsTimeNextVisible);
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public MessageIdsUpdateHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsPopreceipt() {
        return this.xMsPopreceipt;
    }

    public MessageIdsUpdateHeaders setXMsPopreceipt(String xMsPopreceipt) {
        this.xMsPopreceipt = xMsPopreceipt;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public MessageIdsUpdateHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

