/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueRetentionPolicy
implements XmlSerializable<QueueRetentionPolicy> {
    private boolean enabled;
    private Integer days;

    public boolean isEnabled() {
        return this.enabled;
    }

    public QueueRetentionPolicy setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Integer getDays() {
        return this.days;
    }

    public QueueRetentionPolicy setDays(Integer days) {
        this.days = days;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "QueueRetentionPolicy" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeNumberElement("Days", (Number)this.days);
        return xmlWriter.writeEndElement();
    }

    public static QueueRetentionPolicy fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueRetentionPolicy.fromXml(xmlReader, null);
    }

    public static QueueRetentionPolicy fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "QueueRetentionPolicy" : rootElementName;
        return (QueueRetentionPolicy)xmlReader.readObject(finalRootElementName, reader -> {
            QueueRetentionPolicy deserializedQueueRetentionPolicy = new QueueRetentionPolicy();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedQueueRetentionPolicy.enabled = reader.getBooleanElement();
                    continue;
                }
                if ("Days".equals(elementName.getLocalPart())) {
                    deserializedQueueRetentionPolicy.days = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedQueueRetentionPolicy;
        });
    }
}

