/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.exception;

import com.azure.cosmos.CosmosException;
import com.azure.spring.data.cosmos.common.CosmosUtils;
import com.azure.spring.data.cosmos.core.ResponseDiagnosticsProcessor;
import com.azure.spring.data.cosmos.exception.CosmosAccessException;
import com.azure.spring.data.cosmos.exception.CosmosBadRequestException;
import com.azure.spring.data.cosmos.exception.CosmosConflictException;
import com.azure.spring.data.cosmos.exception.CosmosForbiddenException;
import com.azure.spring.data.cosmos.exception.CosmosGoneException;
import com.azure.spring.data.cosmos.exception.CosmosInternalServerErrorException;
import com.azure.spring.data.cosmos.exception.CosmosInvalidPartitionException;
import com.azure.spring.data.cosmos.exception.CosmosMethodNotAllowedException;
import com.azure.spring.data.cosmos.exception.CosmosNotFoundException;
import com.azure.spring.data.cosmos.exception.CosmosOperationCancelledException;
import com.azure.spring.data.cosmos.exception.CosmosPartitionIsMigratingException;
import com.azure.spring.data.cosmos.exception.CosmosPartitionKeyRangeGoneException;
import com.azure.spring.data.cosmos.exception.CosmosPartitionKeyRangeIsSplittingException;
import com.azure.spring.data.cosmos.exception.CosmosPreconditionFailedException;
import com.azure.spring.data.cosmos.exception.CosmosRequestEntityTooLargeException;
import com.azure.spring.data.cosmos.exception.CosmosRequestRateTooLargeException;
import com.azure.spring.data.cosmos.exception.CosmosRequestTimeoutException;
import com.azure.spring.data.cosmos.exception.CosmosRetryWithException;
import com.azure.spring.data.cosmos.exception.CosmosServiceUnavailableException;
import com.azure.spring.data.cosmos.exception.CosmosUnauthorizedException;
import org.springframework.http.HttpStatus;
import org.springframework.util.ObjectUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosExceptionUtils {
    public static <T> Mono<T> exceptionHandler(String message, Throwable throwable, ResponseDiagnosticsProcessor responseDiagnosticsProcessor) {
        CosmosAccessException cosmosAccessException;
        Throwable unwrappedThrowable;
        if (ObjectUtils.isEmpty((Object)message)) {
            message = "Failed to access cosmos db database";
        }
        if ((unwrappedThrowable = Exceptions.unwrap((Throwable)throwable)) instanceof CosmosException) {
            CosmosException cosmosException = (CosmosException)unwrappedThrowable;
            CosmosUtils.fillAndProcessCosmosExceptionDiagnostics(responseDiagnosticsProcessor, cosmosException);
            int statusCode = cosmosException.getStatusCode();
            int subStatusCode = ((CosmosException)unwrappedThrowable).getSubStatusCode();
            cosmosAccessException = statusCode == HttpStatus.BAD_REQUEST.value() ? new CosmosBadRequestException(message, (Throwable)cosmosException) : (statusCode == HttpStatus.CONFLICT.value() ? new CosmosConflictException(message, (Throwable)cosmosException) : (statusCode == HttpStatus.FORBIDDEN.value() ? new CosmosForbiddenException(message, (Throwable)cosmosException) : (statusCode == HttpStatus.GONE.value() ? (subStatusCode == 1000 ? new CosmosInvalidPartitionException(message, (Throwable)cosmosException) : (subStatusCode == 1008 ? new CosmosPartitionIsMigratingException(message, (Throwable)cosmosException) : (subStatusCode == 1002 ? new CosmosPartitionKeyRangeGoneException(message, (Throwable)cosmosException) : (subStatusCode == 1007 ? new CosmosPartitionKeyRangeIsSplittingException(message, (Throwable)cosmosException) : new CosmosGoneException(message, (Throwable)cosmosException))))) : (statusCode == HttpStatus.INTERNAL_SERVER_ERROR.value() ? new CosmosInternalServerErrorException(message, (Throwable)cosmosException) : (statusCode == HttpStatus.METHOD_NOT_ALLOWED.value() ? new CosmosMethodNotAllowedException(message, (Throwable)cosmosException) : (statusCode == HttpStatus.NOT_FOUND.value() ? new CosmosNotFoundException(message, (Throwable)cosmosException) : (statusCode == HttpStatus.REQUEST_TIMEOUT.value() ? (subStatusCode == 20008 ? new CosmosOperationCancelledException(message, (Throwable)cosmosException) : new CosmosRequestTimeoutException(message, (Throwable)cosmosException)) : (statusCode == HttpStatus.PRECONDITION_FAILED.value() ? new CosmosPreconditionFailedException(message, (Throwable)cosmosException) : (statusCode == HttpStatus.PAYLOAD_TOO_LARGE.value() ? new CosmosRequestEntityTooLargeException(message, (Throwable)cosmosException) : (statusCode == HttpStatus.TOO_MANY_REQUESTS.value() ? new CosmosRequestRateTooLargeException(message, (Throwable)cosmosException) : (statusCode == 449 ? new CosmosRetryWithException(message, (Throwable)cosmosException) : (statusCode == HttpStatus.SERVICE_UNAVAILABLE.value() ? new CosmosServiceUnavailableException(message, (Throwable)cosmosException) : (statusCode == HttpStatus.UNAUTHORIZED.value() ? new CosmosUnauthorizedException(message, (Throwable)cosmosException) : new CosmosAccessException(message, (Exception)cosmosException))))))))))))));
        } else {
            cosmosAccessException = new CosmosAccessException(message, unwrappedThrowable);
        }
        throw cosmosAccessException;
    }

    public static <T> Mono<T> findAPIExceptionHandler(String message, Throwable throwable, ResponseDiagnosticsProcessor responseDiagnosticsProcessor) {
        Throwable unwrappedThrowable;
        if (ObjectUtils.isEmpty((Object)message)) {
            message = "Failed to find item";
        }
        if ((unwrappedThrowable = Exceptions.unwrap((Throwable)throwable)) instanceof CosmosException) {
            CosmosException cosmosClientException = (CosmosException)unwrappedThrowable;
            CosmosUtils.fillAndProcessCosmosExceptionDiagnostics(responseDiagnosticsProcessor, cosmosClientException);
            if (cosmosClientException.getStatusCode() == 404) {
                return Mono.empty();
            }
        }
        throw new CosmosAccessException(message, unwrappedThrowable);
    }
}

