/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.mapping;

import com.azure.spring.data.cosmos.core.mapping.BasicCosmosPersistentEntity;
import com.azure.spring.data.cosmos.core.mapping.BasicCosmosPersistentProperty;
import com.azure.spring.data.cosmos.core.mapping.CosmosPersistentProperty;
import com.azure.spring.data.cosmos.core.mapping.CosmosSimpleTypes;
import org.springframework.context.ApplicationContext;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;

public class CosmosMappingContext
extends AbstractMappingContext<BasicCosmosPersistentEntity<?>, CosmosPersistentProperty> {
    private ApplicationContext context;

    public CosmosMappingContext() {
        this.setSimpleTypeHolder(CosmosSimpleTypes.HOLDER);
    }

    protected <T> BasicCosmosPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        BasicCosmosPersistentEntity<T> entity = new BasicCosmosPersistentEntity<T>(typeInformation);
        if (this.context != null) {
            entity.setApplicationContext(this.context);
        }
        return entity;
    }

    public CosmosPersistentProperty createPersistentProperty(Property property, BasicCosmosPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new BasicCosmosPersistentProperty(property, owner, simpleTypeHolder);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }
}

