/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.query;

import com.azure.spring.data.cosmos.core.query.CriteriaType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.lang.NonNull;

public final class Criteria {
    private String subject;
    private List<Object> subjectValues;
    private final CriteriaType type;
    private final List<Criteria> subCriteria;
    private Part.IgnoreCaseType ignoreCase;

    public Part.IgnoreCaseType getIgnoreCase() {
        return this.ignoreCase;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<Object> getSubjectValues() {
        return this.subjectValues;
    }

    public CriteriaType getType() {
        return this.type;
    }

    public List<Criteria> getSubCriteria() {
        return this.subCriteria;
    }

    private Criteria(CriteriaType type) {
        this.type = type;
        this.subCriteria = new ArrayList<Criteria>();
    }

    public static Criteria getInstance(CriteriaType type, @NonNull String subject, @NonNull List<Object> values, @NonNull Part.IgnoreCaseType ignoreCase) {
        Criteria criteria = new Criteria(type);
        criteria.subject = subject;
        criteria.subjectValues = values;
        criteria.ignoreCase = ignoreCase;
        return criteria;
    }

    public static Criteria getInstance(CriteriaType type, @NonNull Criteria left, @NonNull Criteria right) {
        Criteria criteria = new Criteria(type);
        criteria.subCriteria.add(left);
        criteria.subCriteria.add(right);
        return criteria;
    }

    public static Criteria getInstance(CriteriaType type) {
        return new Criteria(type);
    }
}

