/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.support;

import com.azure.spring.data.cosmos.core.ReactiveCosmosOperations;
import com.azure.spring.data.cosmos.repository.query.PartTreeReactiveCosmosQuery;
import com.azure.spring.data.cosmos.repository.query.ReactiveCosmosQueryMethod;
import com.azure.spring.data.cosmos.repository.support.CosmosEntityInformation;
import com.azure.spring.data.cosmos.repository.support.SimpleReactiveCosmosRepository;
import com.azure.spring.data.cosmos.repository.support.StringBasedReactiveCosmosQuery;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class ReactiveCosmosRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private final ReactiveCosmosOperations cosmosOperations;

    public ReactiveCosmosRepositoryFactory(ReactiveCosmosOperations cosmosOperations) {
        this.cosmosOperations = cosmosOperations;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainType) {
        return new CosmosEntityInformation(domainType);
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.cosmosOperations});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleReactiveCosmosRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new ReactiveCosmosQueryLookupStrategy(this.cosmosOperations, evaluationContextProvider));
    }

    private static class ReactiveCosmosQueryLookupStrategy
    implements QueryLookupStrategy {
        private final ReactiveCosmosOperations cosmosOperations;

        ReactiveCosmosQueryLookupStrategy(ReactiveCosmosOperations operations, QueryMethodEvaluationContextProvider provider) {
            this.cosmosOperations = operations;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            ReactiveCosmosQueryMethod queryMethod = new ReactiveCosmosQueryMethod(method, metadata, factory);
            Assert.notNull((Object)((Object)queryMethod), (String)"queryMethod must not be null!");
            Assert.notNull((Object)this.cosmosOperations, (String)"dbOperations must not be null!");
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedReactiveCosmosQuery(queryMethod, this.cosmosOperations);
            }
            return new PartTreeReactiveCosmosQuery(queryMethod, this.cosmosOperations);
        }
    }
}

