/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.repository.query;

import com.azure.spring.data.cosmos.core.CosmosOperations;
import com.azure.spring.data.cosmos.core.mapping.CosmosPersistentProperty;
import com.azure.spring.data.cosmos.core.query.CosmosQuery;
import com.azure.spring.data.cosmos.repository.query.AbstractCosmosQuery;
import com.azure.spring.data.cosmos.repository.query.CosmosParameterAccessor;
import com.azure.spring.data.cosmos.repository.query.CosmosQueryCreator;
import com.azure.spring.data.cosmos.repository.query.CosmosQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeCosmosQuery
extends AbstractCosmosQuery {
    private final PartTree tree;
    private final MappingContext<?, CosmosPersistentProperty> mappingContext;
    private final ResultProcessor processor;

    public PartTreeCosmosQuery(CosmosQueryMethod method, CosmosOperations operations) {
        super(method, operations);
        this.processor = method.getResultProcessor();
        this.tree = new PartTree(method.getName(), this.processor.getReturnedType().getDomainType());
        this.mappingContext = operations.getConverter().getMappingContext();
    }

    @Override
    protected CosmosQuery createQuery(CosmosParameterAccessor accessor) {
        Integer limit;
        CosmosQueryCreator creator = new CosmosQueryCreator(this.tree, accessor, this.mappingContext);
        CosmosQuery query = (CosmosQuery)creator.createQuery();
        if (this.tree.isLimiting() && (limit = this.tree.getMaxResults()) != null) {
            query.setLimit(limit);
        }
        return query;
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }

    @Override
    protected boolean isCountQuery() {
        return this.tree.isCountProjection();
    }
}

