/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class Memoizer<I, O> {
    private final Map<I, O> cache = new ConcurrentHashMap<I, O>();

    private Memoizer() {
    }

    public static <I, O> Function<I, O> memoize(Function<I, O> function) {
        return super.internalMemoize(function);
    }

    private Function<I, O> internalMemoize(Function<I, O> function) {
        return input -> this.cache.computeIfAbsent(input, function);
    }
}

