/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.generator;

import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.spring.data.cosmos.core.generator.AbstractQueryGenerator;
import java.util.Locale;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class NativeQueryGenerator {
    private static final NativeQueryGenerator INSTANCE = new NativeQueryGenerator();

    public static NativeQueryGenerator getInstance() {
        return INSTANCE;
    }

    private SqlQuerySpec cloneWithQueryText(SqlQuerySpec querySpec, String queryText) {
        SqlQuerySpec clone = new SqlQuerySpec();
        clone.setQueryText(queryText);
        clone.setParameters(querySpec.getParameters());
        return clone;
    }

    public SqlQuerySpec generateSortedQuery(SqlQuerySpec querySpec, Sort sort) {
        if (sort == null || sort.isUnsorted()) {
            return querySpec;
        }
        String querySort = AbstractQueryGenerator.generateQuerySort(sort);
        String queryText = "select * from (" + querySpec.getQueryText() + ") r " + querySort;
        return this.cloneWithQueryText(querySpec, queryText);
    }

    public SqlQuerySpec generateCountQuery(SqlQuerySpec querySpec) {
        String queryText = querySpec.getQueryText();
        int fromIndex = queryText.toLowerCase(Locale.US).indexOf(" from ");
        Assert.isTrue((fromIndex >= 0 ? 1 : 0) != 0, (String)("query missing from keyword, query=" + queryText));
        String countQueryText = "select value count(1) " + queryText.substring(fromIndex);
        return this.cloneWithQueryText(querySpec, countQueryText);
    }
}

