// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/** The secret update parameters. */
@Fluent
public final class SecretUpdateParameters implements JsonSerializable<SecretUpdateParameters> {
    /*
     * Type of the secret value such as a password.
     */
    private String contentType;

    /*
     * The secret management attributes.
     */
    private SecretAttributes secretAttributes;

    /*
     * Application specific metadata in the form of key-value pairs.
     */
    private Map<String, String> tags;

    /** Creates an instance of SecretUpdateParameters class. */
    public SecretUpdateParameters() {}

    /**
     * Get the contentType property: Type of the secret value such as a password.
     *
     * @return the contentType value.
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: Type of the secret value such as a password.
     *
     * @param contentType the contentType value to set.
     * @return the SecretUpdateParameters object itself.
     */
    public SecretUpdateParameters setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the secretAttributes property: The secret management attributes.
     *
     * @return the secretAttributes value.
     */
    public SecretAttributes getSecretAttributes() {
        return this.secretAttributes;
    }

    /**
     * Set the secretAttributes property: The secret management attributes.
     *
     * @param secretAttributes the secretAttributes value to set.
     * @return the SecretUpdateParameters object itself.
     */
    public SecretUpdateParameters setSecretAttributes(SecretAttributes secretAttributes) {
        this.secretAttributes = secretAttributes;
        return this;
    }

    /**
     * Get the tags property: Application specific metadata in the form of key-value pairs.
     *
     * @return the tags value.
     */
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Application specific metadata in the form of key-value pairs.
     *
     * @param tags the tags value to set.
     * @return the SecretUpdateParameters object itself.
     */
    public SecretUpdateParameters setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", this.secretAttributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecretUpdateParameters from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecretUpdateParameters if the JsonReader was pointing to an instance of it, or null if it
     *     was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecretUpdateParameters.
     */
    public static SecretUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(
                reader -> {
                    SecretUpdateParameters deserializedSecretUpdateParameters = new SecretUpdateParameters();
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();

                        if ("contentType".equals(fieldName)) {
                            deserializedSecretUpdateParameters.contentType = reader.getString();
                        } else if ("attributes".equals(fieldName)) {
                            deserializedSecretUpdateParameters.secretAttributes = SecretAttributes.fromJson(reader);
                        } else if ("tags".equals(fieldName)) {
                            Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                            deserializedSecretUpdateParameters.tags = tags;
                        } else {
                            reader.skipChildren();
                        }
                    }

                    return deserializedSecretUpdateParameters;
                });
    }
}
