// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.secrets.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.secrets.implementation.models.BackupSecretResult;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretItem;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretListResult;
import com.azure.security.keyvault.secrets.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import com.azure.security.keyvault.secrets.implementation.models.SecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.SecretItem;
import com.azure.security.keyvault.secrets.implementation.models.SecretListResult;
import com.azure.security.keyvault.secrets.implementation.models.SecretRestoreParameters;
import com.azure.security.keyvault.secrets.implementation.models.SecretSetParameters;
import com.azure.security.keyvault.secrets.implementation.models.SecretUpdateParameters;
import java.util.Map;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the SecretClient type. */
public final class SecretClientImpl {
    /** The proxy service used to perform REST calls. */
    private final SecretClientService service;

    /** Api Version. */
    private final String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of SecretClient client.
     *
     * @param apiVersion Api Version.
     */
    public SecretClientImpl(String apiVersion) {
        this(
                new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
                JacksonAdapter.createDefaultSerializerAdapter(),
                apiVersion);
    }

    /**
     * Initializes an instance of SecretClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param apiVersion Api Version.
     */
    public SecretClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    /**
     * Initializes an instance of SecretClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param apiVersion Api Version.
     */
    public SecretClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.service = RestProxy.create(SecretClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for SecretClient to be used by the proxy service to perform REST calls.
     */
    @Host("{vaultBaseUrl}")
    @ServiceInterface(name = "SecretClient")
    public interface SecretClientService {
        @Put("/secrets/{secret-name}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<SecretBundle>> setSecret(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") SecretSetParameters parameters,
                @HeaderParam("Accept") String accept,
                @HeaderParam("Content-Type") String contentType,
                Context context);

        @Put("/secrets/{secret-name}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<SecretBundle> setSecretSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") SecretSetParameters parameters,
                @HeaderParam("Accept") String accept,
                @HeaderParam("Content-Type") String contentType,
                Context context);

        @Delete("/secrets/{secret-name}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedSecretBundle>> deleteSecret(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/secrets/{secret-name}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedSecretBundle> deleteSecretSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/secrets/{secret-name}/{secret-version}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<SecretBundle>> updateSecret(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @PathParam("secret-version") String secretVersion,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") SecretUpdateParameters parameters,
                @HeaderParam("Accept") String accept,
                @HeaderParam("Content-Type") String contentType,
                Context context);

        @Patch("/secrets/{secret-name}/{secret-version}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<SecretBundle> updateSecretSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @PathParam("secret-version") String secretVersion,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") SecretUpdateParameters parameters,
                @HeaderParam("Accept") String accept,
                @HeaderParam("Content-Type") String contentType,
                Context context);

        @Get("/secrets/{secret-name}/{secret-version}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<SecretBundle>> getSecret(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @PathParam("secret-version") String secretVersion,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/secrets/{secret-name}/{secret-version}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<SecretBundle> getSecretSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @PathParam("secret-version") String secretVersion,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/secrets")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<SecretListResult>> getSecrets(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @QueryParam("maxresults") Integer maxresults,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/secrets")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<SecretListResult> getSecretsSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @QueryParam("maxresults") Integer maxresults,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/secrets/{secret-name}/versions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<SecretListResult>> getSecretVersions(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("maxresults") Integer maxresults,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/secrets/{secret-name}/versions")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<SecretListResult> getSecretVersionsSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("maxresults") Integer maxresults,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/deletedsecrets")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedSecretListResult>> getDeletedSecrets(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @QueryParam("maxresults") Integer maxresults,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/deletedsecrets")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedSecretListResult> getDeletedSecretsSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @QueryParam("maxresults") Integer maxresults,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/deletedsecrets/{secret-name}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedSecretBundle>> getDeletedSecret(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/deletedsecrets/{secret-name}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedSecretBundle> getDeletedSecretSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/deletedsecrets/{secret-name}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<Void>> purgeDeletedSecret(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/deletedsecrets/{secret-name}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<Void> purgeDeletedSecretSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/deletedsecrets/{secret-name}/recover")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<SecretBundle>> recoverDeletedSecret(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/deletedsecrets/{secret-name}/recover")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<SecretBundle> recoverDeletedSecretSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/secrets/{secret-name}/backup")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<BackupSecretResult>> backupSecret(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/secrets/{secret-name}/backup")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<BackupSecretResult> backupSecretSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @PathParam("secret-name") String secretName,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/secrets/restore")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<SecretBundle>> restoreSecret(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") SecretRestoreParameters parameters,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/secrets/restore")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<SecretBundle> restoreSecretSync(
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") SecretRestoreParameters parameters,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<SecretListResult>> getSecretsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<SecretListResult> getSecretsNextSync(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<SecretListResult>> getSecretVersionsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<SecretListResult> getSecretVersionsNextSync(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Mono<Response<DeletedSecretListResult>> getDeletedSecretsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(KeyVaultErrorException.class)
        Response<DeletedSecretListResult> getDeletedSecretsNextSync(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("vaultBaseUrl") String vaultBaseUrl,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Sets a secret in a specified key vault.
     *
     * <p>The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault
     * creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param value The value of the secret.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> setSecretWithResponseAsync(
            String vaultBaseUrl,
            String secretName,
            String value,
            Map<String, String> tags,
            String secretContentType,
            SecretAttributes secretAttributes) {
        final String accept = "application/json";
        final String contentType = "application/json";
        SecretSetParameters parameters = new SecretSetParameters();
        parameters.setValue(value);
        parameters.setTags(tags);
        parameters.setContentType(secretContentType);
        parameters.setSecretAttributes(secretAttributes);
        return FluxUtil.withContext(
                context ->
                        service.setSecret(
                                vaultBaseUrl,
                                secretName,
                                this.getApiVersion(),
                                parameters,
                                accept,
                                contentType,
                                context));
    }

    /**
     * Sets a secret in a specified key vault.
     *
     * <p>The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault
     * creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param value The value of the secret.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> setSecretWithResponseAsync(
            String vaultBaseUrl,
            String secretName,
            String value,
            Map<String, String> tags,
            String secretContentType,
            SecretAttributes secretAttributes,
            Context context) {
        final String accept = "application/json";
        final String contentType = "application/json";
        SecretSetParameters parameters = new SecretSetParameters();
        parameters.setValue(value);
        parameters.setTags(tags);
        parameters.setContentType(secretContentType);
        parameters.setSecretAttributes(secretAttributes);
        return service.setSecret(
                vaultBaseUrl, secretName, this.getApiVersion(), parameters, accept, contentType, context);
    }

    /**
     * Sets a secret in a specified key vault.
     *
     * <p>The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault
     * creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param value The value of the secret.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SecretBundle> setSecretAsync(
            String vaultBaseUrl,
            String secretName,
            String value,
            Map<String, String> tags,
            String secretContentType,
            SecretAttributes secretAttributes) {
        return setSecretWithResponseAsync(vaultBaseUrl, secretName, value, tags, secretContentType, secretAttributes)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Sets a secret in a specified key vault.
     *
     * <p>The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault
     * creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param value The value of the secret.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SecretBundle> setSecretAsync(
            String vaultBaseUrl,
            String secretName,
            String value,
            Map<String, String> tags,
            String secretContentType,
            SecretAttributes secretAttributes,
            Context context) {
        return setSecretWithResponseAsync(
                        vaultBaseUrl, secretName, value, tags, secretContentType, secretAttributes, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Sets a secret in a specified key vault.
     *
     * <p>The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault
     * creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param value The value of the secret.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SecretBundle> setSecretWithResponse(
            String vaultBaseUrl,
            String secretName,
            String value,
            Map<String, String> tags,
            String secretContentType,
            SecretAttributes secretAttributes,
            Context context) {
        final String accept = "application/json";
        final String contentType = "application/json";
        SecretSetParameters parameters = new SecretSetParameters();
        parameters.setValue(value);
        parameters.setTags(tags);
        parameters.setContentType(secretContentType);
        parameters.setSecretAttributes(secretAttributes);
        return service.setSecretSync(
                vaultBaseUrl, secretName, this.getApiVersion(), parameters, accept, contentType, context);
    }

    /**
     * Sets a secret in a specified key vault.
     *
     * <p>The SET operation adds a secret to the Azure Key Vault. If the named secret already exists, Azure Key Vault
     * creates a new version of that secret. This operation requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret. The value you provide may be copied globally for the purpose of running
     *     the service. The value provided should not include personally identifiable or sensitive information.
     * @param value The value of the secret.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SecretBundle setSecret(
            String vaultBaseUrl,
            String secretName,
            String value,
            Map<String, String> tags,
            String secretContentType,
            SecretAttributes secretAttributes) {
        return setSecretWithResponse(
                        vaultBaseUrl, secretName, value, tags, secretContentType, secretAttributes, Context.NONE)
                .getValue();
    }

    /**
     * Deletes a secret from a specified key vault.
     *
     * <p>The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an
     * individual version of a secret. This operation requires the secrets/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedSecretBundle>> deleteSecretWithResponseAsync(String vaultBaseUrl, String secretName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.deleteSecret(vaultBaseUrl, secretName, this.getApiVersion(), accept, context));
    }

    /**
     * Deletes a secret from a specified key vault.
     *
     * <p>The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an
     * individual version of a secret. This operation requires the secrets/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedSecretBundle>> deleteSecretWithResponseAsync(
            String vaultBaseUrl, String secretName, Context context) {
        final String accept = "application/json";
        return service.deleteSecret(vaultBaseUrl, secretName, this.getApiVersion(), accept, context);
    }

    /**
     * Deletes a secret from a specified key vault.
     *
     * <p>The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an
     * individual version of a secret. This operation requires the secrets/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedSecretBundle> deleteSecretAsync(String vaultBaseUrl, String secretName) {
        return deleteSecretWithResponseAsync(vaultBaseUrl, secretName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes a secret from a specified key vault.
     *
     * <p>The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an
     * individual version of a secret. This operation requires the secrets/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedSecretBundle> deleteSecretAsync(String vaultBaseUrl, String secretName, Context context) {
        return deleteSecretWithResponseAsync(vaultBaseUrl, secretName, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Deletes a secret from a specified key vault.
     *
     * <p>The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an
     * individual version of a secret. This operation requires the secrets/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeletedSecretBundle> deleteSecretWithResponse(
            String vaultBaseUrl, String secretName, Context context) {
        final String accept = "application/json";
        return service.deleteSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), accept, context);
    }

    /**
     * Deletes a secret from a specified key vault.
     *
     * <p>The DELETE operation applies to any secret stored in Azure Key Vault. DELETE cannot be applied to an
     * individual version of a secret. This operation requires the secrets/delete permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeletedSecretBundle deleteSecret(String vaultBaseUrl, String secretName) {
        return deleteSecretWithResponse(vaultBaseUrl, secretName, Context.NONE).getValue();
    }

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     *
     * <p>The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not
     * specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation
     * requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> updateSecretWithResponseAsync(
            String vaultBaseUrl,
            String secretName,
            String secretVersion,
            String secretContentType,
            SecretAttributes secretAttributes,
            Map<String, String> tags) {
        final String accept = "application/json";
        final String contentType = "application/json";
        SecretUpdateParameters parameters = new SecretUpdateParameters();
        parameters.setContentType(secretContentType);
        parameters.setSecretAttributes(secretAttributes);
        parameters.setTags(tags);
        return FluxUtil.withContext(
                context ->
                        service.updateSecret(
                                vaultBaseUrl,
                                secretName,
                                secretVersion,
                                this.getApiVersion(),
                                parameters,
                                accept,
                                contentType,
                                context));
    }

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     *
     * <p>The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not
     * specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation
     * requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> updateSecretWithResponseAsync(
            String vaultBaseUrl,
            String secretName,
            String secretVersion,
            String secretContentType,
            SecretAttributes secretAttributes,
            Map<String, String> tags,
            Context context) {
        final String accept = "application/json";
        final String contentType = "application/json";
        SecretUpdateParameters parameters = new SecretUpdateParameters();
        parameters.setContentType(secretContentType);
        parameters.setSecretAttributes(secretAttributes);
        parameters.setTags(tags);
        return service.updateSecret(
                vaultBaseUrl,
                secretName,
                secretVersion,
                this.getApiVersion(),
                parameters,
                accept,
                contentType,
                context);
    }

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     *
     * <p>The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not
     * specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation
     * requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SecretBundle> updateSecretAsync(
            String vaultBaseUrl,
            String secretName,
            String secretVersion,
            String secretContentType,
            SecretAttributes secretAttributes,
            Map<String, String> tags) {
        return updateSecretWithResponseAsync(
                        vaultBaseUrl, secretName, secretVersion, secretContentType, secretAttributes, tags)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     *
     * <p>The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not
     * specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation
     * requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SecretBundle> updateSecretAsync(
            String vaultBaseUrl,
            String secretName,
            String secretVersion,
            String secretContentType,
            SecretAttributes secretAttributes,
            Map<String, String> tags,
            Context context) {
        return updateSecretWithResponseAsync(
                        vaultBaseUrl, secretName, secretVersion, secretContentType, secretAttributes, tags, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     *
     * <p>The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not
     * specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation
     * requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SecretBundle> updateSecretWithResponse(
            String vaultBaseUrl,
            String secretName,
            String secretVersion,
            String secretContentType,
            SecretAttributes secretAttributes,
            Map<String, String> tags,
            Context context) {
        final String accept = "application/json";
        final String contentType = "application/json";
        SecretUpdateParameters parameters = new SecretUpdateParameters();
        parameters.setContentType(secretContentType);
        parameters.setSecretAttributes(secretAttributes);
        parameters.setTags(tags);
        return service.updateSecretSync(
                vaultBaseUrl,
                secretName,
                secretVersion,
                this.getApiVersion(),
                parameters,
                accept,
                contentType,
                context);
    }

    /**
     * Updates the attributes associated with a specified secret in a given key vault.
     *
     * <p>The UPDATE operation changes specified attributes of an existing stored secret. Attributes that are not
     * specified in the request are left unchanged. The value of a secret itself cannot be changed. This operation
     * requires the secrets/set permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret.
     * @param secretContentType Type of the secret value such as a password.
     * @param secretAttributes The secret management attributes.
     * @param tags Application specific metadata in the form of key-value pairs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SecretBundle updateSecret(
            String vaultBaseUrl,
            String secretName,
            String secretVersion,
            String secretContentType,
            SecretAttributes secretAttributes,
            Map<String, String> tags) {
        return updateSecretWithResponse(
                        vaultBaseUrl, secretName, secretVersion, secretContentType, secretAttributes, tags, Context.NONE)
                .getValue();
    }

    /**
     * Get a specified secret from a given key vault.
     *
     * <p>The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the
     * secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret. This URI fragment is optional. If not specified, the latest
     *     version of the secret is returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> getSecretWithResponseAsync(
            String vaultBaseUrl, String secretName, String secretVersion) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getSecret(
                                vaultBaseUrl, secretName, secretVersion, this.getApiVersion(), accept, context));
    }

    /**
     * Get a specified secret from a given key vault.
     *
     * <p>The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the
     * secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret. This URI fragment is optional. If not specified, the latest
     *     version of the secret is returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> getSecretWithResponseAsync(
            String vaultBaseUrl, String secretName, String secretVersion, Context context) {
        final String accept = "application/json";
        return service.getSecret(vaultBaseUrl, secretName, secretVersion, this.getApiVersion(), accept, context);
    }

    /**
     * Get a specified secret from a given key vault.
     *
     * <p>The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the
     * secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret. This URI fragment is optional. If not specified, the latest
     *     version of the secret is returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, String secretVersion) {
        return getSecretWithResponseAsync(vaultBaseUrl, secretName, secretVersion)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get a specified secret from a given key vault.
     *
     * <p>The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the
     * secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret. This URI fragment is optional. If not specified, the latest
     *     version of the secret is returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SecretBundle> getSecretAsync(
            String vaultBaseUrl, String secretName, String secretVersion, Context context) {
        return getSecretWithResponseAsync(vaultBaseUrl, secretName, secretVersion, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get a specified secret from a given key vault.
     *
     * <p>The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the
     * secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret. This URI fragment is optional. If not specified, the latest
     *     version of the secret is returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SecretBundle> getSecretWithResponse(
            String vaultBaseUrl, String secretName, String secretVersion, Context context) {
        final String accept = "application/json";
        return service.getSecretSync(vaultBaseUrl, secretName, secretVersion, this.getApiVersion(), accept, context);
    }

    /**
     * Get a specified secret from a given key vault.
     *
     * <p>The GET operation is applicable to any secret stored in Azure Key Vault. This operation requires the
     * secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param secretVersion The version of the secret. This URI fragment is optional. If not specified, the latest
     *     version of the secret is returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SecretBundle getSecret(String vaultBaseUrl, String secretName, String secretVersion) {
        return getSecretWithResponse(vaultBaseUrl, secretName, secretVersion, Context.NONE).getValue();
    }

    /**
     * List secrets in a specified key vault.
     *
     * <p>The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its
     * attributes are provided in the response. Individual secret versions are not listed in the response. This
     * operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretsSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.getSecrets(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List secrets in a specified key vault.
     *
     * <p>The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its
     * attributes are provided in the response. Individual secret versions are not listed in the response. This
     * operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretsSinglePageAsync(
            String vaultBaseUrl, Integer maxresults, Context context) {
        final String accept = "application/json";
        return service.getSecrets(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List secrets in a specified key vault.
     *
     * <p>The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its
     * attributes are provided in the response. Individual secret versions are not listed in the response. This
     * operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SecretItem> getSecretsAsync(String vaultBaseUrl, Integer maxresults) {
        return new PagedFlux<>(
                () -> getSecretsSinglePageAsync(vaultBaseUrl, maxresults),
                nextLink -> getSecretsNextSinglePageAsync(nextLink, vaultBaseUrl));
    }

    /**
     * List secrets in a specified key vault.
     *
     * <p>The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its
     * attributes are provided in the response. Individual secret versions are not listed in the response. This
     * operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SecretItem> getSecretsAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedFlux<>(
                () -> getSecretsSinglePageAsync(vaultBaseUrl, maxresults, context),
                nextLink -> getSecretsNextSinglePageAsync(nextLink, vaultBaseUrl, context));
    }

    /**
     * List secrets in a specified key vault.
     *
     * <p>The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its
     * attributes are provided in the response. Individual secret versions are not listed in the response. This
     * operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretsSinglePage(String vaultBaseUrl, Integer maxresults) {
        final String accept = "application/json";
        Response<SecretListResult> res =
                service.getSecretsSync(vaultBaseUrl, maxresults, this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List secrets in a specified key vault.
     *
     * <p>The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its
     * attributes are provided in the response. Individual secret versions are not listed in the response. This
     * operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretsSinglePage(String vaultBaseUrl, Integer maxresults, Context context) {
        final String accept = "application/json";
        Response<SecretListResult> res =
                service.getSecretsSync(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List secrets in a specified key vault.
     *
     * <p>The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its
     * attributes are provided in the response. Individual secret versions are not listed in the response. This
     * operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SecretItem> getSecrets(String vaultBaseUrl, Integer maxresults) {
        return new PagedIterable<>(
                () -> getSecretsSinglePage(vaultBaseUrl, maxresults, Context.NONE),
                nextLink -> getSecretsNextSinglePage(nextLink, vaultBaseUrl));
    }

    /**
     * List secrets in a specified key vault.
     *
     * <p>The Get Secrets operation is applicable to the entire vault. However, only the base secret identifier and its
     * attributes are provided in the response. Individual secret versions are not listed in the response. This
     * operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SecretItem> getSecrets(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedIterable<>(
                () -> getSecretsSinglePage(vaultBaseUrl, maxresults, context),
                nextLink -> getSecretsNextSinglePage(nextLink, vaultBaseUrl, context));
    }

    /**
     * List all versions of the specified secret.
     *
     * <p>The full secret identifier and attributes are provided in the response. No values are returned for the
     * secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretVersionsSinglePageAsync(
            String vaultBaseUrl, String secretName, Integer maxresults) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getSecretVersions(
                                        vaultBaseUrl, secretName, maxresults, this.getApiVersion(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all versions of the specified secret.
     *
     * <p>The full secret identifier and attributes are provided in the response. No values are returned for the
     * secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretVersionsSinglePageAsync(
            String vaultBaseUrl, String secretName, Integer maxresults, Context context) {
        final String accept = "application/json";
        return service.getSecretVersions(vaultBaseUrl, secretName, maxresults, this.getApiVersion(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all versions of the specified secret.
     *
     * <p>The full secret identifier and attributes are provided in the response. No values are returned for the
     * secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SecretItem> getSecretVersionsAsync(String vaultBaseUrl, String secretName, Integer maxresults) {
        return new PagedFlux<>(
                () -> getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName, maxresults),
                nextLink -> getSecretVersionsNextSinglePageAsync(nextLink, vaultBaseUrl));
    }

    /**
     * List all versions of the specified secret.
     *
     * <p>The full secret identifier and attributes are provided in the response. No values are returned for the
     * secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SecretItem> getSecretVersionsAsync(
            String vaultBaseUrl, String secretName, Integer maxresults, Context context) {
        return new PagedFlux<>(
                () -> getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName, maxresults, context),
                nextLink -> getSecretVersionsNextSinglePageAsync(nextLink, vaultBaseUrl, context));
    }

    /**
     * List all versions of the specified secret.
     *
     * <p>The full secret identifier and attributes are provided in the response. No values are returned for the
     * secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretVersionsSinglePage(
            String vaultBaseUrl, String secretName, Integer maxresults) {
        final String accept = "application/json";
        Response<SecretListResult> res =
                service.getSecretVersionsSync(
                        vaultBaseUrl, secretName, maxresults, this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List all versions of the specified secret.
     *
     * <p>The full secret identifier and attributes are provided in the response. No values are returned for the
     * secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretVersionsSinglePage(
            String vaultBaseUrl, String secretName, Integer maxresults, Context context) {
        final String accept = "application/json";
        Response<SecretListResult> res =
                service.getSecretVersionsSync(
                        vaultBaseUrl, secretName, maxresults, this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List all versions of the specified secret.
     *
     * <p>The full secret identifier and attributes are provided in the response. No values are returned for the
     * secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SecretItem> getSecretVersions(String vaultBaseUrl, String secretName, Integer maxresults) {
        return new PagedIterable<>(
                () -> getSecretVersionsSinglePage(vaultBaseUrl, secretName, maxresults, Context.NONE),
                nextLink -> getSecretVersionsNextSinglePage(nextLink, vaultBaseUrl));
    }

    /**
     * List all versions of the specified secret.
     *
     * <p>The full secret identifier and attributes are provided in the response. No values are returned for the
     * secrets. This operations requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param maxresults Maximum number of results to return in a page. If not specified, the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SecretItem> getSecretVersions(
            String vaultBaseUrl, String secretName, Integer maxresults, Context context) {
        return new PagedIterable<>(
                () -> getSecretVersionsSinglePage(vaultBaseUrl, secretName, maxresults, context),
                nextLink -> getSecretVersionsNextSinglePage(nextLink, vaultBaseUrl, context));
    }

    /**
     * Lists deleted secrets for the specified vault.
     *
     * <p>The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for
     * soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedSecretItem>> getDeletedSecretsSinglePageAsync(
            String vaultBaseUrl, Integer maxresults) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getDeletedSecrets(
                                        vaultBaseUrl, maxresults, this.getApiVersion(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Lists deleted secrets for the specified vault.
     *
     * <p>The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for
     * soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedSecretItem>> getDeletedSecretsSinglePageAsync(
            String vaultBaseUrl, Integer maxresults, Context context) {
        final String accept = "application/json";
        return service.getDeletedSecrets(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Lists deleted secrets for the specified vault.
     *
     * <p>The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for
     * soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeletedSecretItem> getDeletedSecretsAsync(String vaultBaseUrl, Integer maxresults) {
        return new PagedFlux<>(
                () -> getDeletedSecretsSinglePageAsync(vaultBaseUrl, maxresults),
                nextLink -> getDeletedSecretsNextSinglePageAsync(nextLink, vaultBaseUrl));
    }

    /**
     * Lists deleted secrets for the specified vault.
     *
     * <p>The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for
     * soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DeletedSecretItem> getDeletedSecretsAsync(
            String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedFlux<>(
                () -> getDeletedSecretsSinglePageAsync(vaultBaseUrl, maxresults, context),
                nextLink -> getDeletedSecretsNextSinglePageAsync(nextLink, vaultBaseUrl, context));
    }

    /**
     * Lists deleted secrets for the specified vault.
     *
     * <p>The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for
     * soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedSecretItem> getDeletedSecretsSinglePage(String vaultBaseUrl, Integer maxresults) {
        final String accept = "application/json";
        Response<DeletedSecretListResult> res =
                service.getDeletedSecretsSync(vaultBaseUrl, maxresults, this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Lists deleted secrets for the specified vault.
     *
     * <p>The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for
     * soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedSecretItem> getDeletedSecretsSinglePage(
            String vaultBaseUrl, Integer maxresults, Context context) {
        final String accept = "application/json";
        Response<DeletedSecretListResult> res =
                service.getDeletedSecretsSync(vaultBaseUrl, maxresults, this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Lists deleted secrets for the specified vault.
     *
     * <p>The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for
     * soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeletedSecretItem> getDeletedSecrets(String vaultBaseUrl, Integer maxresults) {
        return new PagedIterable<>(
                () -> getDeletedSecretsSinglePage(vaultBaseUrl, maxresults, Context.NONE),
                nextLink -> getDeletedSecretsNextSinglePage(nextLink, vaultBaseUrl));
    }

    /**
     * Lists deleted secrets for the specified vault.
     *
     * <p>The Get Deleted Secrets operation returns the secrets that have been deleted for a vault enabled for
     * soft-delete. This operation requires the secrets/list permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param maxresults Maximum number of results to return in a page. If not specified the service will return up to
     *     25 results.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DeletedSecretItem> getDeletedSecrets(
            String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedIterable<>(
                () -> getDeletedSecretsSinglePage(vaultBaseUrl, maxresults, context),
                nextLink -> getDeletedSecretsNextSinglePage(nextLink, vaultBaseUrl, context));
    }

    /**
     * Gets the specified deleted secret.
     *
     * <p>The Get Deleted Secret operation returns the specified deleted secret along with its attributes. This
     * operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedSecretBundle>> getDeletedSecretWithResponseAsync(
            String vaultBaseUrl, String secretName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.getDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), accept, context));
    }

    /**
     * Gets the specified deleted secret.
     *
     * <p>The Get Deleted Secret operation returns the specified deleted secret along with its attributes. This
     * operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DeletedSecretBundle>> getDeletedSecretWithResponseAsync(
            String vaultBaseUrl, String secretName, Context context) {
        final String accept = "application/json";
        return service.getDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), accept, context);
    }

    /**
     * Gets the specified deleted secret.
     *
     * <p>The Get Deleted Secret operation returns the specified deleted secret along with its attributes. This
     * operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedSecretBundle> getDeletedSecretAsync(String vaultBaseUrl, String secretName) {
        return getDeletedSecretWithResponseAsync(vaultBaseUrl, secretName)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the specified deleted secret.
     *
     * <p>The Get Deleted Secret operation returns the specified deleted secret along with its attributes. This
     * operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DeletedSecretBundle> getDeletedSecretAsync(String vaultBaseUrl, String secretName, Context context) {
        return getDeletedSecretWithResponseAsync(vaultBaseUrl, secretName, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the specified deleted secret.
     *
     * <p>The Get Deleted Secret operation returns the specified deleted secret along with its attributes. This
     * operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DeletedSecretBundle> getDeletedSecretWithResponse(
            String vaultBaseUrl, String secretName, Context context) {
        final String accept = "application/json";
        return service.getDeletedSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), accept, context);
    }

    /**
     * Gets the specified deleted secret.
     *
     * <p>The Get Deleted Secret operation returns the specified deleted secret along with its attributes. This
     * operation requires the secrets/get permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
     *     it will be purged.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DeletedSecretBundle getDeletedSecret(String vaultBaseUrl, String secretName) {
        return getDeletedSecretWithResponse(vaultBaseUrl, secretName, Context.NONE).getValue();
    }

    /**
     * Permanently deletes the specified secret.
     *
     * <p>The purge deleted secret operation removes the secret permanently, without the possibility of recovery. This
     * operation can only be enabled on a soft-delete enabled vault. This operation requires the secrets/purge
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedSecretWithResponseAsync(String vaultBaseUrl, String secretName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.purgeDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), accept, context));
    }

    /**
     * Permanently deletes the specified secret.
     *
     * <p>The purge deleted secret operation removes the secret permanently, without the possibility of recovery. This
     * operation can only be enabled on a soft-delete enabled vault. This operation requires the secrets/purge
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedSecretWithResponseAsync(
            String vaultBaseUrl, String secretName, Context context) {
        final String accept = "application/json";
        return service.purgeDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), accept, context);
    }

    /**
     * Permanently deletes the specified secret.
     *
     * <p>The purge deleted secret operation removes the secret permanently, without the possibility of recovery. This
     * operation can only be enabled on a soft-delete enabled vault. This operation requires the secrets/purge
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purgeDeletedSecretAsync(String vaultBaseUrl, String secretName) {
        return purgeDeletedSecretWithResponseAsync(vaultBaseUrl, secretName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Permanently deletes the specified secret.
     *
     * <p>The purge deleted secret operation removes the secret permanently, without the possibility of recovery. This
     * operation can only be enabled on a soft-delete enabled vault. This operation requires the secrets/purge
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purgeDeletedSecretAsync(String vaultBaseUrl, String secretName, Context context) {
        return purgeDeletedSecretWithResponseAsync(vaultBaseUrl, secretName, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Permanently deletes the specified secret.
     *
     * <p>The purge deleted secret operation removes the secret permanently, without the possibility of recovery. This
     * operation can only be enabled on a soft-delete enabled vault. This operation requires the secrets/purge
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> purgeDeletedSecretWithResponse(String vaultBaseUrl, String secretName, Context context) {
        final String accept = "application/json";
        return service.purgeDeletedSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), accept, context);
    }

    /**
     * Permanently deletes the specified secret.
     *
     * <p>The purge deleted secret operation removes the secret permanently, without the possibility of recovery. This
     * operation can only be enabled on a soft-delete enabled vault. This operation requires the secrets/purge
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void purgeDeletedSecret(String vaultBaseUrl, String secretName) {
        purgeDeletedSecretWithResponse(vaultBaseUrl, secretName, Context.NONE);
    }

    /**
     * Recovers the deleted secret to the latest version.
     *
     * <p>Recovers the deleted secret in the specified vault. This operation can only be performed on a soft-delete
     * enabled vault. This operation requires the secrets/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the deleted secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> recoverDeletedSecretWithResponseAsync(String vaultBaseUrl, String secretName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.recoverDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), accept, context));
    }

    /**
     * Recovers the deleted secret to the latest version.
     *
     * <p>Recovers the deleted secret in the specified vault. This operation can only be performed on a soft-delete
     * enabled vault. This operation requires the secrets/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the deleted secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> recoverDeletedSecretWithResponseAsync(
            String vaultBaseUrl, String secretName, Context context) {
        final String accept = "application/json";
        return service.recoverDeletedSecret(vaultBaseUrl, secretName, this.getApiVersion(), accept, context);
    }

    /**
     * Recovers the deleted secret to the latest version.
     *
     * <p>Recovers the deleted secret in the specified vault. This operation can only be performed on a soft-delete
     * enabled vault. This operation requires the secrets/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the deleted secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SecretBundle> recoverDeletedSecretAsync(String vaultBaseUrl, String secretName) {
        return recoverDeletedSecretWithResponseAsync(vaultBaseUrl, secretName)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Recovers the deleted secret to the latest version.
     *
     * <p>Recovers the deleted secret in the specified vault. This operation can only be performed on a soft-delete
     * enabled vault. This operation requires the secrets/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the deleted secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SecretBundle> recoverDeletedSecretAsync(String vaultBaseUrl, String secretName, Context context) {
        return recoverDeletedSecretWithResponseAsync(vaultBaseUrl, secretName, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Recovers the deleted secret to the latest version.
     *
     * <p>Recovers the deleted secret in the specified vault. This operation can only be performed on a soft-delete
     * enabled vault. This operation requires the secrets/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the deleted secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SecretBundle> recoverDeletedSecretWithResponse(
            String vaultBaseUrl, String secretName, Context context) {
        final String accept = "application/json";
        return service.recoverDeletedSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), accept, context);
    }

    /**
     * Recovers the deleted secret to the latest version.
     *
     * <p>Recovers the deleted secret in the specified vault. This operation can only be performed on a soft-delete
     * enabled vault. This operation requires the secrets/recover permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the deleted secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SecretBundle recoverDeletedSecret(String vaultBaseUrl, String secretName) {
        return recoverDeletedSecretWithResponse(vaultBaseUrl, secretName, Context.NONE).getValue();
    }

    /**
     * Backs up the specified secret.
     *
     * <p>Requests that a backup of the specified secret be downloaded to the client. All versions of the secret will be
     * downloaded. This operation requires the secrets/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup secret result, containing the backup blob along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BackupSecretResult>> backupSecretWithResponseAsync(String vaultBaseUrl, String secretName) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.backupSecret(vaultBaseUrl, secretName, this.getApiVersion(), accept, context));
    }

    /**
     * Backs up the specified secret.
     *
     * <p>Requests that a backup of the specified secret be downloaded to the client. All versions of the secret will be
     * downloaded. This operation requires the secrets/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup secret result, containing the backup blob along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BackupSecretResult>> backupSecretWithResponseAsync(
            String vaultBaseUrl, String secretName, Context context) {
        final String accept = "application/json";
        return service.backupSecret(vaultBaseUrl, secretName, this.getApiVersion(), accept, context);
    }

    /**
     * Backs up the specified secret.
     *
     * <p>Requests that a backup of the specified secret be downloaded to the client. All versions of the secret will be
     * downloaded. This operation requires the secrets/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup secret result, containing the backup blob on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupSecretResult> backupSecretAsync(String vaultBaseUrl, String secretName) {
        return backupSecretWithResponseAsync(vaultBaseUrl, secretName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Backs up the specified secret.
     *
     * <p>Requests that a backup of the specified secret be downloaded to the client. All versions of the secret will be
     * downloaded. This operation requires the secrets/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup secret result, containing the backup blob on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupSecretResult> backupSecretAsync(String vaultBaseUrl, String secretName, Context context) {
        return backupSecretWithResponseAsync(vaultBaseUrl, secretName, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Backs up the specified secret.
     *
     * <p>Requests that a backup of the specified secret be downloaded to the client. All versions of the secret will be
     * downloaded. This operation requires the secrets/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup secret result, containing the backup blob along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BackupSecretResult> backupSecretWithResponse(
            String vaultBaseUrl, String secretName, Context context) {
        final String accept = "application/json";
        return service.backupSecretSync(vaultBaseUrl, secretName, this.getApiVersion(), accept, context);
    }

    /**
     * Backs up the specified secret.
     *
     * <p>Requests that a backup of the specified secret be downloaded to the client. All versions of the secret will be
     * downloaded. This operation requires the secrets/backup permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretName The name of the secret.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the backup secret result, containing the backup blob.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupSecretResult backupSecret(String vaultBaseUrl, String secretName) {
        return backupSecretWithResponse(vaultBaseUrl, secretName, Context.NONE).getValue();
    }

    /**
     * Restores a backed up secret to a vault.
     *
     * <p>Restores a backed up secret, and all its versions, to a vault. This operation requires the secrets/restore
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretBundleBackup The backup blob associated with a secret bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> restoreSecretWithResponseAsync(String vaultBaseUrl, byte[] secretBundleBackup) {
        final String accept = "application/json";
        SecretRestoreParameters parameters = new SecretRestoreParameters();
        parameters.setSecretBundleBackup(secretBundleBackup);
        return FluxUtil.withContext(
                context -> service.restoreSecret(vaultBaseUrl, this.getApiVersion(), parameters, accept, context));
    }

    /**
     * Restores a backed up secret to a vault.
     *
     * <p>Restores a backed up secret, and all its versions, to a vault. This operation requires the secrets/restore
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretBundleBackup The backup blob associated with a secret bundle.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SecretBundle>> restoreSecretWithResponseAsync(
            String vaultBaseUrl, byte[] secretBundleBackup, Context context) {
        final String accept = "application/json";
        SecretRestoreParameters parameters = new SecretRestoreParameters();
        parameters.setSecretBundleBackup(secretBundleBackup);
        return service.restoreSecret(vaultBaseUrl, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Restores a backed up secret to a vault.
     *
     * <p>Restores a backed up secret, and all its versions, to a vault. This operation requires the secrets/restore
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretBundleBackup The backup blob associated with a secret bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SecretBundle> restoreSecretAsync(String vaultBaseUrl, byte[] secretBundleBackup) {
        return restoreSecretWithResponseAsync(vaultBaseUrl, secretBundleBackup)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Restores a backed up secret to a vault.
     *
     * <p>Restores a backed up secret, and all its versions, to a vault. This operation requires the secrets/restore
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretBundleBackup The backup blob associated with a secret bundle.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SecretBundle> restoreSecretAsync(String vaultBaseUrl, byte[] secretBundleBackup, Context context) {
        return restoreSecretWithResponseAsync(vaultBaseUrl, secretBundleBackup, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Restores a backed up secret to a vault.
     *
     * <p>Restores a backed up secret, and all its versions, to a vault. This operation requires the secrets/restore
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretBundleBackup The backup blob associated with a secret bundle.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SecretBundle> restoreSecretWithResponse(
            String vaultBaseUrl, byte[] secretBundleBackup, Context context) {
        final String accept = "application/json";
        SecretRestoreParameters parameters = new SecretRestoreParameters();
        parameters.setSecretBundleBackup(secretBundleBackup);
        return service.restoreSecretSync(vaultBaseUrl, this.getApiVersion(), parameters, accept, context);
    }

    /**
     * Restores a backed up secret to a vault.
     *
     * <p>Restores a backed up secret, and all its versions, to a vault. This operation requires the secrets/restore
     * permission.
     *
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param secretBundleBackup The backup blob associated with a secret bundle.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a secret consisting of a value, id and its attributes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SecretBundle restoreSecret(String vaultBaseUrl, byte[] secretBundleBackup) {
        return restoreSecretWithResponse(vaultBaseUrl, secretBundleBackup, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretsNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getSecretsNext(nextLink, vaultBaseUrl, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretsNextSinglePageAsync(
            String nextLink, String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        return service.getSecretsNext(nextLink, vaultBaseUrl, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretsNextSinglePage(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        Response<SecretListResult> res = service.getSecretsNextSync(nextLink, vaultBaseUrl, accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretsNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        Response<SecretListResult> res = service.getSecretsNextSync(nextLink, vaultBaseUrl, accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretVersionsNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getSecretVersionsNext(nextLink, vaultBaseUrl, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<SecretItem>> getSecretVersionsNextSinglePageAsync(
            String nextLink, String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        return service.getSecretVersionsNext(nextLink, vaultBaseUrl, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretVersionsNextSinglePage(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        Response<SecretListResult> res =
                service.getSecretVersionsNextSync(nextLink, vaultBaseUrl, accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<SecretItem> getSecretVersionsNextSinglePage(
            String nextLink, String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        Response<SecretListResult> res = service.getSecretVersionsNextSync(nextLink, vaultBaseUrl, accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedSecretItem>> getDeletedSecretsNextSinglePageAsync(
            String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getDeletedSecretsNext(nextLink, vaultBaseUrl, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedSecretItem>> getDeletedSecretsNextSinglePageAsync(
            String nextLink, String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        return service.getDeletedSecretsNext(nextLink, vaultBaseUrl, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedSecretItem> getDeletedSecretsNextSinglePage(String nextLink, String vaultBaseUrl) {
        final String accept = "application/json";
        Response<DeletedSecretListResult> res =
                service.getDeletedSecretsNextSync(nextLink, vaultBaseUrl, accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param vaultBaseUrl The vault name, for example https://myvault.vault.azure.net.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws KeyVaultErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the deleted secret list result along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DeletedSecretItem> getDeletedSecretsNextSinglePage(
            String nextLink, String vaultBaseUrl, Context context) {
        final String accept = "application/json";
        Response<DeletedSecretListResult> res =
                service.getDeletedSecretsNextSync(nextLink, vaultBaseUrl, accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }
}
