/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretServiceVersion;
import com.azure.security.keyvault.secrets.implementation.KeyVaultCredentialPolicy;
import com.azure.security.keyvault.secrets.implementation.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.secrets.implementation.SecretClientImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ServiceClientBuilder(serviceClients={SecretClient.class})
public final class SecretClientBuilder
implements TokenCredentialTrait<SecretClientBuilder>,
HttpTrait<SecretClientBuilder>,
ConfigurationTrait<SecretClientBuilder> {
    private final ClientLogger logger = new ClientLogger(SecretClientBuilder.class);
    private static final String AZURE_KEY_VAULT_SECRETS = "azure-key-vault-secrets.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final List<HttpPipelinePolicy> perCallPolicies;
    private final List<HttpPipelinePolicy> perRetryPolicies;
    private final Map<String, String> properties;
    private TokenCredential credential;
    private HttpPipeline pipeline;
    private String vaultUrl;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private SecretServiceVersion version;
    private ClientOptions clientOptions;

    public SecretClientBuilder() {
        this.perCallPolicies = new ArrayList<HttpPipelinePolicy>();
        this.perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
        this.properties = CoreUtils.getProperties((String)AZURE_KEY_VAULT_SECRETS);
    }

    public SecretClient buildClient() {
        return new SecretClient(this.buildInnerClient());
    }

    public SecretAsyncClient buildAsyncClient() {
        return new SecretAsyncClient(this.buildInnerClient());
    }

    private SecretClientImpl buildInnerClient() {
        SecretServiceVersion serviceVersion;
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        String buildEndpoint = this.getBuildEndpoint(buildConfiguration);
        if (buildEndpoint == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required")));
        }
        SecretServiceVersion secretServiceVersion = serviceVersion = this.version != null ? this.version : SecretServiceVersion.getLatest();
        if (this.pipeline != null) {
            return new SecretClientImpl(this.vaultUrl, this.pipeline, serviceVersion);
        }
        if (this.credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(KeyVaultErrorCodeStrings.getErrorString("credential_required")));
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        this.httpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        policies.add(new UserAgentPolicy(CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions), clientName, clientVersion, buildConfiguration));
        if (this.clientOptions != null) {
            ArrayList httpHeaderList = new ArrayList();
            this.clientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
            policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        }
        policies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions));
        policies.add((Object)new KeyVaultCredentialPolicy(this.credential));
        policies.addAll(this.perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        return new SecretClientImpl(this.vaultUrl, pipeline, serviceVersion);
    }

    public SecretClientBuilder vaultUrl(String vaultUrl) {
        if (vaultUrl == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'vaultUrl' cannot be null."));
        }
        try {
            URL url = new URL(vaultUrl);
            this.vaultUrl = url.toString();
        }
        catch (MalformedURLException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Key Vault url is malformed.", e));
        }
        return this;
    }

    public SecretClientBuilder credential(TokenCredential credential) {
        if (credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'credential' cannot be null."));
        }
        this.credential = credential;
        return this;
    }

    public SecretClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public SecretClientBuilder addPolicy(HttpPipelinePolicy policy) {
        if (policy == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'policy' cannot be null."));
        }
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public SecretClientBuilder httpClient(HttpClient client) {
        this.httpClient = client;
        return this;
    }

    public SecretClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public SecretClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public SecretClientBuilder serviceVersion(SecretServiceVersion version) {
        this.version = version;
        return this;
    }

    public SecretClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public SecretClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public SecretClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    private String getBuildEndpoint(Configuration configuration) {
        if (this.vaultUrl != null) {
            return this.vaultUrl;
        }
        String configEndpoint = configuration.get("AZURE_KEYVAULT_ENDPOINT");
        if (CoreUtils.isNullOrEmpty((CharSequence)configEndpoint)) {
            return null;
        }
        try {
            URL url = new URL(configEndpoint);
            return url.toString();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }
}

