/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.secrets.implementation.models.DeletionRecoveryLevel;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class SecretAttributes
implements JsonSerializable<SecretAttributes> {
    private Boolean enabled;
    private Long notBefore;
    private Long expires;
    private Long created;
    private Long updated;
    private Integer recoverableDays;
    private DeletionRecoveryLevel recoveryLevel;

    public Boolean isEnabled() {
        return this.enabled;
    }

    public SecretAttributes setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime getNotBefore() {
        if (this.notBefore == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.notBefore), ZoneOffset.UTC);
    }

    public SecretAttributes setNotBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore == null ? null : Long.valueOf(notBefore.toEpochSecond());
        return this;
    }

    public OffsetDateTime getExpires() {
        if (this.expires == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expires), ZoneOffset.UTC);
    }

    public SecretAttributes setExpires(OffsetDateTime expires) {
        this.expires = expires == null ? null : Long.valueOf(expires.toEpochSecond());
        return this;
    }

    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    public DeletionRecoveryLevel getRecoveryLevel() {
        return this.recoveryLevel;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("nbf", (Number)this.notBefore);
        jsonWriter.writeNumberField("exp", (Number)this.expires);
        return jsonWriter.writeEndObject();
    }

    public static SecretAttributes fromJson(JsonReader jsonReader) throws IOException {
        return (SecretAttributes)jsonReader.readObject(reader -> {
            SecretAttributes deserializedSecretAttributes = new SecretAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedSecretAttributes.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("nbf".equals(fieldName)) {
                    deserializedSecretAttributes.notBefore = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("exp".equals(fieldName)) {
                    deserializedSecretAttributes.expires = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedSecretAttributes.created = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedSecretAttributes.updated = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("recoverableDays".equals(fieldName)) {
                    deserializedSecretAttributes.recoverableDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("recoveryLevel".equals(fieldName)) {
                    deserializedSecretAttributes.recoveryLevel = DeletionRecoveryLevel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretAttributes;
        });
    }
}

