/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import java.io.IOException;
import java.util.Map;

public final class SecretBundle
implements JsonSerializable<SecretBundle> {
    private String value;
    private String id;
    private String contentType;
    private SecretAttributes attributes;
    private Map<String, String> tags;
    private String kid;
    private Boolean managed;

    private SecretBundle() {
    }

    public String getValue() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public String getContentType() {
        return this.contentType;
    }

    public SecretAttributes getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getKid() {
        return this.kid;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SecretBundle fromJson(JsonReader jsonReader) throws IOException {
        return (SecretBundle)jsonReader.readObject(reader -> {
            SecretBundle deserializedSecretBundle = new SecretBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedSecretBundle.value = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedSecretBundle.id = reader.getString();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedSecretBundle.contentType = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedSecretBundle.attributes = SecretAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSecretBundle.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    deserializedSecretBundle.kid = reader.getString();
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedSecretBundle.managed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretBundle;
        });
    }
}

