/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.implementation.SecretClientImpl;
import com.azure.security.keyvault.secrets.implementation.models.BackupSecretResult;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretItem;
import com.azure.security.keyvault.secrets.implementation.models.SecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.SecretItem;
import com.azure.security.keyvault.secrets.implementation.models.SecretRestoreParameters;
import com.azure.security.keyvault.secrets.implementation.models.SecretSetParameters;
import com.azure.security.keyvault.secrets.implementation.models.SecretUpdateParameters;
import com.azure.security.keyvault.secrets.implementation.models.SecretsModelsUtils;
import com.azure.security.keyvault.secrets.models.DeletedSecret;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;

@ServiceClient(builder=SecretClientBuilder.class, serviceInterfaces={SecretClientImpl.SecretClientService.class})
public final class SecretClient {
    private static final ClientLogger LOGGER = new ClientLogger(SecretClient.class);
    private final SecretClientImpl implClient;
    private final String vaultUrl;

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    SecretClient(SecretClientImpl implClient, String vaultUrl) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret setSecret(KeyVaultSecret secret) {
        return SecretClient.callWithMappedException(() -> SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)this.implClient.setSecretWithResponse(secret.getName(), BinaryData.fromObject((Object)SecretClient.prepareSecretSetParameters(secret)), SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(SecretBundle.class)), SecretAsyncClient::mapSetSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret setSecret(String name, String value) {
        return SecretClient.callWithMappedException(() -> SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)this.implClient.setSecretWithResponse(name, BinaryData.fromObject((Object)new SecretSetParameters(value)), SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(SecretBundle.class)), SecretAsyncClient::mapSetSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> setSecretWithResponse(KeyVaultSecret secret, Context context) {
        return (Response)SecretClient.callWithMappedException(() -> {
            Response<BinaryData> response = this.implClient.setSecretWithResponse(secret.getName(), BinaryData.fromObject((Object)SecretClient.prepareSecretSetParameters(secret)), new RequestOptions().setContext(context));
            return new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class)));
        }, SecretAsyncClient::mapSetSecretException);
    }

    static SecretSetParameters prepareSecretSetParameters(KeyVaultSecret secret) {
        SecretSetParameters secretSetParameters = new SecretSetParameters(secret.getValue());
        SecretProperties secretProperties = secret.getProperties();
        if (secretProperties != null) {
            secretSetParameters.setTags(secretProperties.getTags()).setContentType(secretProperties.getContentType()).setSecretAttributes(SecretsModelsUtils.createSecretAttributes(secretProperties));
        }
        return secretSetParameters;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret getSecret(String name) {
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'name' cannot be null or empty."));
        }
        return SecretClient.callWithMappedException(() -> SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)this.implClient.getSecretWithResponse(name, "", SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(SecretBundle.class)), SecretAsyncClient::mapGetSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret getSecret(String name, String version) {
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'name' cannot be null or empty."));
        }
        return SecretClient.callWithMappedException(() -> SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)this.implClient.getSecretWithResponse(name, version, SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(SecretBundle.class)), SecretAsyncClient::mapGetSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> getSecretWithResponse(String name, String version, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'name' cannot be null or empty."));
        }
        return (Response)SecretClient.callWithMappedException(() -> {
            Response<BinaryData> response = this.implClient.getSecretWithResponse(name, version, new RequestOptions().setContext(context));
            return new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class)));
        }, SecretAsyncClient::mapGetSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretProperties updateSecretProperties(SecretProperties secretProperties) {
        return SecretsModelsUtils.createSecretProperties((SecretBundle)((BinaryData)this.implClient.updateSecretWithResponse(secretProperties.getName(), secretProperties.getVersion(), BinaryData.fromObject((Object)SecretClient.prepareUpdateSecretParameters(secretProperties)), SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(SecretBundle.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretProperties> updateSecretPropertiesWithResponse(SecretProperties secretProperties, Context context) {
        Response<BinaryData> response = this.implClient.updateSecretWithResponse(secretProperties.getName(), secretProperties.getVersion(), BinaryData.fromObject((Object)SecretClient.prepareUpdateSecretParameters(secretProperties)), new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)SecretsModelsUtils.createSecretProperties((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class)));
    }

    static SecretUpdateParameters prepareUpdateSecretParameters(SecretProperties secretProperties) {
        SecretUpdateParameters secretUpdateParameters = new SecretUpdateParameters();
        if (secretProperties != null) {
            secretUpdateParameters.setTags(secretProperties.getTags()).setContentType(secretProperties.getContentType()).setSecretAttributes(SecretsModelsUtils.createSecretAttributes(secretProperties));
        }
        return secretUpdateParameters;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedSecret, Void> beginDeleteSecret(String name) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), this.deleteActivationOperation(name), this.deletePollOperation(name), (context, response) -> null, context -> null);
    }

    private Function<PollingContext<DeletedSecret>, PollResponse<DeletedSecret>> deleteActivationOperation(String name) {
        return pollingContext -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)SecretsModelsUtils.createDeletedSecret((DeletedSecretBundle)((BinaryData)this.implClient.deleteSecretWithResponse(name, SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(DeletedSecretBundle.class)));
    }

    private Function<PollingContext<DeletedSecret>, PollResponse<DeletedSecret>> deletePollOperation(String name) {
        return pollingContext -> {
            try {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)SecretsModelsUtils.createDeletedSecret((DeletedSecretBundle)((BinaryData)this.implClient.getDeletedSecretWithResponse(name, SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(DeletedSecretBundle.class)));
            }
            catch (HttpResponseException e) {
                if (e.getResponse().getStatusCode() == 404) {
                    return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue()));
                }
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue()));
            }
            catch (Exception e) {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue()));
            }
        };
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedSecret getDeletedSecret(String name) {
        return SecretsModelsUtils.createDeletedSecret((DeletedSecretBundle)((BinaryData)this.implClient.getDeletedSecretWithResponse(name, SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(DeletedSecretBundle.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedSecret> getDeletedSecretWithResponse(String name, Context context) {
        Response<BinaryData> response = this.implClient.getDeletedSecretWithResponse(name, new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)SecretsModelsUtils.createDeletedSecret((DeletedSecretBundle)((BinaryData)response.getValue()).toObject(DeletedSecretBundle.class)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedSecret(String name) {
        this.implClient.purgeDeletedSecretWithResponse(name, SecretAsyncClient.EMPTY_OPTIONS).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedSecretWithResponse(String name, Context context) {
        return this.implClient.purgeDeletedSecretWithResponse(name, new RequestOptions().setContext(context));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultSecret, Void> beginRecoverDeletedSecret(String name) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), this.recoverActivationOperation(name), this.recoverPollOperation(name), (context, response) -> null, context -> null);
    }

    private Function<PollingContext<KeyVaultSecret>, PollResponse<KeyVaultSecret>> recoverActivationOperation(String name) {
        return pollingContext -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)this.implClient.recoverDeletedSecretWithResponse(name, SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(SecretBundle.class)));
    }

    private Function<PollingContext<KeyVaultSecret>, PollResponse<KeyVaultSecret>> recoverPollOperation(String name) {
        return pollingContext -> {
            try {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)this.implClient.getSecretWithResponse(name, "", SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(SecretBundle.class)));
            }
            catch (HttpResponseException e) {
                if (e.getResponse().getStatusCode() == 404) {
                    return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue()));
                }
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue()));
            }
            catch (Exception e) {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue()));
            }
        };
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupSecret(String name) {
        return ((BackupSecretResult)((BinaryData)this.implClient.backupSecretWithResponse(name, SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(BackupSecretResult.class)).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupSecretWithResponse(String name, Context context) {
        Response<BinaryData> response = this.implClient.backupSecretWithResponse(name, new RequestOptions().setContext(context));
        return new SimpleResponse(response, (Object)((BinaryData)response.getValue()).toBytes());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret restoreSecretBackup(byte[] backup) {
        return SecretClient.callWithMappedException(() -> SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)this.implClient.restoreSecretWithResponse(BinaryData.fromObject((Object)new SecretRestoreParameters(backup)), SecretAsyncClient.EMPTY_OPTIONS).getValue()).toObject(SecretBundle.class)), SecretAsyncClient::mapRestoreSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> restoreSecretBackupWithResponse(byte[] backup, Context context) {
        return (Response)SecretClient.callWithMappedException(() -> {
            Response<BinaryData> response = this.implClient.restoreSecretWithResponse(BinaryData.fromObject((Object)new SecretRestoreParameters(backup)), new RequestOptions().setContext(context));
            return new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)((BinaryData)response.getValue()).toObject(SecretBundle.class)));
        }, SecretAsyncClient::mapRestoreSecretException);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecrets() {
        return this.implClient.getSecrets(SecretAsyncClient.EMPTY_OPTIONS).mapPage(binaryData -> SecretsModelsUtils.createSecretProperties((SecretItem)binaryData.toObject(SecretItem.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecrets(Context context) {
        return this.implClient.getSecrets(new RequestOptions().setContext(context)).mapPage(binaryData -> SecretsModelsUtils.createSecretProperties((SecretItem)binaryData.toObject(SecretItem.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedSecret> listDeletedSecrets() {
        return this.implClient.getDeletedSecrets(SecretAsyncClient.EMPTY_OPTIONS).mapPage(binaryData -> SecretsModelsUtils.createDeletedSecret((DeletedSecretItem)binaryData.toObject(DeletedSecretItem.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedSecret> listDeletedSecrets(Context context) {
        return this.implClient.getDeletedSecrets(new RequestOptions().setContext(context)).mapPage(binaryData -> SecretsModelsUtils.createDeletedSecret((DeletedSecretItem)binaryData.toObject(DeletedSecretItem.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecretVersions(String name) {
        return this.implClient.getSecretVersions(name, SecretAsyncClient.EMPTY_OPTIONS).mapPage(binaryData -> SecretsModelsUtils.createSecretProperties((SecretItem)binaryData.toObject(SecretItem.class)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecretVersions(String name, Context context) {
        return this.implClient.getSecretVersions(name, new RequestOptions().setContext(context)).mapPage(binaryData -> SecretsModelsUtils.createSecretProperties((SecretItem)binaryData.toObject(SecretItem.class)));
    }

    private static <T> T callWithMappedException(Supplier<T> call, Function<HttpResponseException, HttpResponseException> exceptionMapper) {
        try {
            return call.get();
        }
        catch (HttpResponseException e) {
            throw exceptionMapper.apply(e);
        }
    }
}

