/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.security.keyvault.keys.cryptography.KeyOperationParameters;
import com.azure.security.keyvault.keys.cryptography.KeyOperationResult;
import com.azure.security.keyvault.keys.cryptography.KeySignRequest;
import com.azure.security.keyvault.keys.cryptography.KeyVerifyRequest;
import com.azure.security.keyvault.keys.cryptography.KeyVerifyResponse;
import com.azure.security.keyvault.keys.cryptography.KeyWrapUnwrapRequest;
import com.azure.security.keyvault.keys.cryptography.SecretKey;
import com.azure.security.keyvault.keys.cryptography.SecretRequestParameters;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import reactor.core.publisher.Mono;

@Host(value="{url}")
@ServiceInterface(name="KeyVault")
interface CryptographyService {
    @Post(value="keys/{key-name}/{key-version}/encrypt")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyOperationResult>> encrypt(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") KeyOperationParameters var6, @HeaderParam(value="Content-Type") String var7, Context var8);

    @Post(value="keys/{key-name}/{key-version}/decrypt")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyOperationResult>> decrypt(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") KeyOperationParameters var6, @HeaderParam(value="Content-Type") String var7, Context var8);

    @Post(value="keys/{key-name}/{key-version}/sign")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyOperationResult>> sign(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") KeySignRequest var6, @HeaderParam(value="Content-Type") String var7, Context var8);

    @Post(value="keys/{key-name}/{key-version}/verify")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVerifyResponse>> verify(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") KeyVerifyRequest var6, @HeaderParam(value="Content-Type") String var7, Context var8);

    @Post(value="keys/{key-name}/{key-version}/wrapkey")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyOperationResult>> wrapKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") KeyWrapUnwrapRequest var6, @HeaderParam(value="Content-Type") String var7, Context var8);

    @Post(value="keys/{key-name}/{key-version}/unwrapkey")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyOperationResult>> unwrapKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @BodyParam(value="application/json") KeyWrapUnwrapRequest var6, @HeaderParam(value="Content-Type") String var7, Context var8);

    @Get(value="keys/{key-name}/{key-version}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<KeyVaultKey>> getKey(@HostParam(value="url") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Get(value="secrets/{secret-name}/{secret-version}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(code={403}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<SecretKey>> getSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @PathParam(value="secret-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept-language") String var5, @HeaderParam(value="Content-Type") String var6, Context var7);

    @Put(value="secrets/{secret-name}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=ResourceModifiedException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
    public Mono<Response<SecretKey>> setSecret(@HostParam(value="url") String var1, @PathParam(value="secret-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept-language") String var4, @BodyParam(value="application/json") SecretRequestParameters var5, @HeaderParam(value="Content-Type") String var6, Context var7);
}

