/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.CryptographyAsyncClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.Strings;
import com.azure.security.keyvault.keys.implementation.KeyVaultCredentialPolicy;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ServiceClientBuilder(serviceClients={CryptographyClient.class})
public final class CryptographyClientBuilder {
    private final ClientLogger logger = new ClientLogger(CryptographyClientBuilder.class);
    private static final String AZURE_KEY_VAULT_KEYS = "azure-key-vault-keys.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final List<HttpPipelinePolicy> perCallPolicies;
    private final List<HttpPipelinePolicy> perRetryPolicies;
    private final Map<String, String> properties;
    private ClientOptions clientOptions;
    private Configuration configuration;
    private CryptographyServiceVersion version;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline pipeline;
    private JsonWebKey jsonWebKey;
    private RetryPolicy retryPolicy;
    private String keyId;
    private TokenCredential credential;

    public CryptographyClientBuilder() {
        this.perCallPolicies = new ArrayList<HttpPipelinePolicy>();
        this.perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
        this.properties = CoreUtils.getProperties((String)AZURE_KEY_VAULT_KEYS);
        this.retryPolicy = new RetryPolicy();
    }

    public CryptographyClient buildClient() {
        return new CryptographyClient(this.buildAsyncClient());
    }

    public CryptographyAsyncClient buildAsyncClient() {
        if (this.jsonWebKey == null) {
            CryptographyServiceVersion serviceVersion;
            if (Strings.isNullOrEmpty(this.keyId)) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("An Azure Key Vault key identifier is required to build the cryptography client if a JSON Web Key is not provided."));
            }
            CryptographyServiceVersion cryptographyServiceVersion = serviceVersion = this.version != null ? this.version : CryptographyServiceVersion.getLatest();
            if (this.pipeline != null) {
                return new CryptographyAsyncClient(this.keyId, this.pipeline, serviceVersion);
            }
            if (this.credential == null) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Azure Key Vault credentials are required to build the cryptography client if a JSON Web Key is not provided."));
            }
            HttpPipeline pipeline = this.setupPipeline();
            return new CryptographyAsyncClient(this.keyId, pipeline, serviceVersion);
        }
        return new CryptographyAsyncClient(this.jsonWebKey);
    }

    HttpPipeline setupPipeline() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        this.httpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        policies.add(new UserAgentPolicy(CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions), clientName, clientVersion, buildConfiguration));
        if (this.clientOptions != null) {
            ArrayList httpHeaderList = new ArrayList();
            this.clientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
            policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        }
        policies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy == null ? new RetryPolicy() : this.retryPolicy);
        policies.add(new KeyVaultCredentialPolicy(this.credential));
        policies.addAll(this.perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
    }

    TokenCredential getCredential() {
        return this.credential;
    }

    HttpPipeline getPipeline() {
        return this.pipeline;
    }

    CryptographyServiceVersion getServiceVersion() {
        return this.version;
    }

    public CryptographyClientBuilder keyIdentifier(String keyId) {
        if (keyId == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'keyId' cannot be null."));
        }
        this.keyId = keyId;
        return this;
    }

    public CryptographyClientBuilder credential(TokenCredential credential) {
        if (credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'credential' cannot be null."));
        }
        this.credential = credential;
        return this;
    }

    public CryptographyClientBuilder jsonWebKey(JsonWebKey jsonWebKey) {
        if (jsonWebKey == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'jsonWebKey' must not be null."));
        }
        this.jsonWebKey = jsonWebKey;
        return this;
    }

    public CryptographyClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public CryptographyClientBuilder addPolicy(HttpPipelinePolicy policy) {
        if (policy == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'policy' cannot be null."));
        }
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public CryptographyClientBuilder httpClient(HttpClient client) {
        this.httpClient = client;
        return this;
    }

    public CryptographyClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public CryptographyClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public CryptographyClientBuilder serviceVersion(CryptographyServiceVersion version) {
        this.version = version;
        return this;
    }

    public CryptographyClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public CryptographyClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }
}

