/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.cryptography.AsyncKeyEncryptionKey;
import com.azure.core.cryptography.AsyncKeyEncryptionKeyResolver;
import com.azure.core.cryptography.KeyEncryptionKey;
import com.azure.core.cryptography.KeyEncryptionKeyResolver;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.CryptographyClientBuilder;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.KeyEncryptionKeyAsyncClient;
import com.azure.security.keyvault.keys.cryptography.KeyEncryptionKeyClient;
import com.azure.security.keyvault.keys.cryptography.Strings;
import reactor.core.publisher.Mono;

@ServiceClientBuilder(serviceClients={KeyEncryptionKeyClient.class, KeyEncryptionKeyAsyncClient.class})
public final class KeyEncryptionKeyClientBuilder
implements KeyEncryptionKeyResolver,
AsyncKeyEncryptionKeyResolver {
    private final ClientLogger logger = new ClientLogger(KeyEncryptionKeyClientBuilder.class);
    private final CryptographyClientBuilder builder = new CryptographyClientBuilder();

    public KeyEncryptionKey buildKeyEncryptionKey(String keyId) {
        return new KeyEncryptionKeyClient((KeyEncryptionKeyAsyncClient)this.buildAsyncKeyEncryptionKey(keyId).block());
    }

    public Mono<? extends AsyncKeyEncryptionKey> buildAsyncKeyEncryptionKey(String keyId) {
        CryptographyServiceVersion serviceVersion;
        this.builder.keyIdentifier(keyId);
        if (Strings.isNullOrEmpty(keyId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Json Web Key or jsonWebKey identifier are required to create key encryption key async client"));
        }
        CryptographyServiceVersion cryptographyServiceVersion = serviceVersion = this.builder.getServiceVersion() != null ? this.builder.getServiceVersion() : CryptographyServiceVersion.getLatest();
        if (this.builder.getPipeline() != null) {
            return Mono.defer(() -> Mono.just((Object)new KeyEncryptionKeyAsyncClient(keyId, this.builder.getPipeline(), serviceVersion)));
        }
        if (this.builder.getCredential() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Azure Key Vault credentials cannot be null and are required to build a key encryption key client."));
        }
        HttpPipeline pipeline = this.builder.setupPipeline();
        return Mono.defer(() -> Mono.just((Object)new KeyEncryptionKeyAsyncClient(keyId, pipeline, serviceVersion)));
    }

    public KeyEncryptionKeyClientBuilder credential(TokenCredential credential) {
        this.builder.credential(credential);
        return this;
    }

    public KeyEncryptionKeyClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.builder.httpLogOptions(logOptions);
        return this;
    }

    public KeyEncryptionKeyClientBuilder addPolicy(HttpPipelinePolicy policy) {
        this.builder.addPolicy(policy);
        return this;
    }

    public KeyEncryptionKeyClientBuilder httpClient(HttpClient client) {
        this.builder.httpClient(client);
        return this;
    }

    public KeyEncryptionKeyClientBuilder pipeline(HttpPipeline pipeline) {
        this.builder.pipeline(pipeline);
        return this;
    }

    public KeyEncryptionKeyClientBuilder configuration(Configuration configuration) {
        this.builder.configuration(configuration);
        return this;
    }

    public KeyEncryptionKeyClientBuilder serviceVersion(CryptographyServiceVersion version) {
        this.builder.serviceVersion(version);
        return this;
    }

    public KeyEncryptionKeyClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.builder.retryPolicy(retryPolicy);
        return this;
    }
}

