/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.keys.KeyBackup;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.keys.KeyImportRequestParameters;
import com.azure.security.keyvault.keys.KeyRequestAttributes;
import com.azure.security.keyvault.keys.KeyRequestParameters;
import com.azure.security.keyvault.keys.KeyRestoreRequestParameters;
import com.azure.security.keyvault.keys.KeyService;
import com.azure.security.keyvault.keys.KeyServiceVersion;
import com.azure.security.keyvault.keys.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.keys.models.CreateEcKeyOptions;
import com.azure.security.keyvault.keys.models.CreateKeyOptions;
import com.azure.security.keyvault.keys.models.CreateRsaKeyOptions;
import com.azure.security.keyvault.keys.models.DeletedKey;
import com.azure.security.keyvault.keys.models.ImportKeyOptions;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import com.azure.security.keyvault.keys.models.KeyOperation;
import com.azure.security.keyvault.keys.models.KeyProperties;
import com.azure.security.keyvault.keys.models.KeyType;
import com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=KeyClientBuilder.class, isAsync=true, serviceInterfaces={KeyService.class})
public final class KeyAsyncClient {
    private final String apiVersion;
    static final String ACCEPT_LANGUAGE = "en-US";
    static final int DEFAULT_MAX_PAGE_RESULTS = 25;
    static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    static final String KEY_VAULT_SCOPE = "https://vault.azure.net/.default";
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(1L);
    private final String vaultUrl;
    private final KeyService service;
    private final ClientLogger logger = new ClientLogger(KeyAsyncClient.class);

    KeyAsyncClient(URL vaultUrl, HttpPipeline pipeline, KeyServiceVersion version) {
        Objects.requireNonNull(vaultUrl, KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required"));
        this.vaultUrl = vaultUrl.toString();
        this.service = (KeyService)RestProxy.create(KeyService.class, (HttpPipeline)pipeline);
        this.apiVersion = version.getVersion();
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    Duration getDefaultPollingInterval() {
        return DEFAULT_POLLING_INTERVAL;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createKey(String name, KeyType keyType) {
        try {
            return FluxUtil.withContext(context -> this.createKeyWithResponse(name, keyType, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createKeyWithResponse(CreateKeyOptions createKeyOptions) {
        try {
            return FluxUtil.withContext(context -> this.createKeyWithResponse(createKeyOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> createKeyWithResponse(String name, KeyType keyType, Context context) {
        KeyRequestParameters parameters = new KeyRequestParameters().setKty(keyType);
        return this.service.createKey(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Created key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createKey(CreateKeyOptions createKeyOptions) {
        try {
            return this.createKeyWithResponse(createKeyOptions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> createKeyWithResponse(CreateKeyOptions createKeyOptions, Context context) {
        Objects.requireNonNull(createKeyOptions, "The key create options parameter cannot be null.");
        context = context == null ? Context.NONE : context;
        KeyRequestParameters parameters = new KeyRequestParameters().setKty(createKeyOptions.getKeyType()).setKeyOps(createKeyOptions.getKeyOperations()).setKeyAttributes(new KeyRequestAttributes(createKeyOptions)).setTags(createKeyOptions.getTags());
        return this.service.createKey(this.vaultUrl, createKeyOptions.getName(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating key - {}", new Object[]{createKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Created key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create key - {}", new Object[]{createKeyOptions.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createRsaKey(CreateRsaKeyOptions createRsaKeyOptions) {
        try {
            return this.createRsaKeyWithResponse(createRsaKeyOptions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createRsaKeyWithResponse(CreateRsaKeyOptions createRsaKeyOptions) {
        try {
            return FluxUtil.withContext(context -> this.createRsaKeyWithResponse(createRsaKeyOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> createRsaKeyWithResponse(CreateRsaKeyOptions createRsaKeyOptions, Context context) {
        Objects.requireNonNull(createRsaKeyOptions, "The Rsa key options parameter cannot be null.");
        context = context == null ? Context.NONE : context;
        KeyRequestParameters parameters = new KeyRequestParameters().setKty(createRsaKeyOptions.getKeyType()).setKeySize(createRsaKeyOptions.getKeySize()).setKeyOps(createRsaKeyOptions.getKeyOperations()).setKeyAttributes(new KeyRequestAttributes(createRsaKeyOptions)).setTags(createRsaKeyOptions.getTags());
        return this.service.createKey(this.vaultUrl, createRsaKeyOptions.getName(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating Rsa key - {}", new Object[]{createRsaKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Created Rsa key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create Rsa key - {}", new Object[]{createRsaKeyOptions.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> createEcKey(CreateEcKeyOptions createEcKeyOptions) {
        try {
            return this.createEcKeyWithResponse(createEcKeyOptions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> createEcKeyWithResponse(CreateEcKeyOptions createEcKeyOptions) {
        try {
            return FluxUtil.withContext(context -> this.createEcKeyWithResponse(createEcKeyOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> createEcKeyWithResponse(CreateEcKeyOptions createEcKeyOptions, Context context) {
        Objects.requireNonNull(createEcKeyOptions, "The Ec key options cannot be null.");
        context = context == null ? Context.NONE : context;
        KeyRequestParameters parameters = new KeyRequestParameters().setKty(createEcKeyOptions.getKeyType()).setCurve(createEcKeyOptions.getCurveName()).setKeyOps(createEcKeyOptions.getKeyOperations()).setKeyAttributes(new KeyRequestAttributes(createEcKeyOptions)).setTags(createEcKeyOptions.getTags());
        return this.service.createKey(this.vaultUrl, createEcKeyOptions.getName(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating Ec key - {}", new Object[]{createEcKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Created Ec key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create Ec key - {}", new Object[]{createEcKeyOptions.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> importKey(String name, JsonWebKey keyMaterial) {
        try {
            return FluxUtil.withContext(context -> this.importKeyWithResponse(name, keyMaterial, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> importKeyWithResponse(String name, JsonWebKey keyMaterial, Context context) {
        KeyImportRequestParameters parameters = new KeyImportRequestParameters().setKey(keyMaterial);
        return this.service.importKey(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Importing key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Imported key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to import key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> importKey(ImportKeyOptions importKeyOptions) {
        try {
            return this.importKeyWithResponse(importKeyOptions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> importKeyWithResponse(ImportKeyOptions importKeyOptions) {
        try {
            return FluxUtil.withContext(context -> this.importKeyWithResponse(importKeyOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> importKeyWithResponse(ImportKeyOptions importKeyOptions, Context context) {
        Objects.requireNonNull(importKeyOptions, "The key import configuration parameter cannot be null.");
        context = context == null ? Context.NONE : context;
        KeyImportRequestParameters parameters = new KeyImportRequestParameters().setKey(importKeyOptions.getKey()).setHsm(importKeyOptions.isHardwareProtected()).setKeyAttributes(new KeyRequestAttributes(importKeyOptions)).setTags(importKeyOptions.getTags());
        return this.service.importKey(this.vaultUrl, importKeyOptions.getName(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Importing key - {}", new Object[]{importKeyOptions.getName()})).doOnSuccess(response -> this.logger.verbose("Imported key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to import key - {}", new Object[]{importKeyOptions.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> getKey(String name, String version) {
        try {
            return this.getKeyWithResponse(name, version).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> getKeyWithResponse(String name, String version) {
        try {
            return FluxUtil.withContext(context -> this.getKeyWithResponse(name, version == null ? "" : version, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> getKeyWithResponse(String name, String version, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getKey(this.vaultUrl, name, version, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Retrieved key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to get key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> getKey(String name) {
        try {
            return this.getKeyWithResponse(name, "").flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> updateKeyPropertiesWithResponse(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        try {
            return FluxUtil.withContext(context -> this.updateKeyPropertiesWithResponse(keyProperties, (Context)context, keyOperations));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> updateKeyProperties(KeyProperties keyProperties, KeyOperation ... keyOperations) {
        try {
            return this.updateKeyPropertiesWithResponse(keyProperties, keyOperations).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> updateKeyPropertiesWithResponse(KeyProperties keyProperties, Context context, KeyOperation ... keyOperations) {
        Objects.requireNonNull(keyProperties, "The key properties input parameter cannot be null.");
        context = context == null ? Context.NONE : context;
        KeyRequestParameters parameters = new KeyRequestParameters().setTags(keyProperties.getTags()).setKeyAttributes(new KeyRequestAttributes(keyProperties));
        if (keyOperations.length > 0) {
            parameters.setKeyOps(Arrays.asList(keyOperations));
        }
        return this.service.updateKey(this.vaultUrl, keyProperties.getName(), keyProperties.getVersion(), this.apiVersion, ACCEPT_LANGUAGE, parameters, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Updating key - {}", new Object[]{keyProperties.getName()})).doOnSuccess(response -> this.logger.verbose("Updated key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to update key - {}", new Object[]{keyProperties.getName(), error}));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DeletedKey, Void> beginDeleteKey(String name) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.activationOperation(name), this.createPollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<DeletedKey>, Mono<DeletedKey>> activationOperation(String name) {
        return pollingContext -> FluxUtil.withContext(context -> this.deleteKeyWithResponse(name, (Context)context)).flatMap(deletedKeyResponse -> Mono.just((Object)((DeletedKey)deletedKeyResponse.getValue())));
    }

    private Function<PollingContext<DeletedKey>, Mono<PollResponse<DeletedKey>>> createPollOperation(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getDeletedKeyPoller(this.vaultUrl, keyName, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(deletedKeyResponse -> {
            if (deletedKeyResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)deletedKeyResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedKey)pollingContext.getLatestResponse().getValue())));
    }

    Mono<Response<DeletedKey>> deleteKeyWithResponse(String name, Context context) {
        return this.service.deleteKey(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Deleting key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Deleted key - {}", new Object[]{((DeletedKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to delete key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedKey> getDeletedKey(String name) {
        try {
            return this.getDeletedKeyWithResponse(name).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedKey>> getDeletedKeyWithResponse(String name) {
        try {
            return FluxUtil.withContext(context -> this.getDeletedKeyWithResponse(name, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<DeletedKey>> getDeletedKeyWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.getDeletedKey(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving deleted key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Retrieved deleted key - {}", new Object[]{((DeletedKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to get key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedKey(String name) {
        try {
            return this.purgeDeletedKeyWithResponse(name).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedKeyWithResponse(String name) {
        try {
            return FluxUtil.withContext(context -> this.purgeDeletedKeyWithResponse(name, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> purgeDeletedKeyWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.purgeDeletedKey(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Purging deleted key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Purged deleted key - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to purge deleted key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultKey, Void> beginRecoverDeletedKey(String name) {
        return new PollerFlux(this.getDefaultPollingInterval(), this.recoverActivationOperation(name), this.createRecoverPollOperation(name), (context, firstResponse) -> Mono.empty(), context -> Mono.empty());
    }

    private Function<PollingContext<KeyVaultKey>, Mono<KeyVaultKey>> recoverActivationOperation(String name) {
        return pollingContext -> FluxUtil.withContext(context -> this.recoverDeletedKeyWithResponse(name, (Context)context)).flatMap(keyResponse -> Mono.just((Object)((KeyVaultKey)keyResponse.getValue())));
    }

    private Function<PollingContext<KeyVaultKey>, Mono<PollResponse<KeyVaultKey>>> createRecoverPollOperation(String keyName) {
        return pollingContext -> FluxUtil.withContext(context -> this.service.getKeyPoller(this.vaultUrl, keyName, "", this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE))).flatMap(keyResponse -> {
            if (keyResponse.getStatusCode() == 404) {
                return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue()))));
            }
            return Mono.defer(() -> Mono.just((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)keyResponse.getValue()))));
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultKey)pollingContext.getLatestResponse().getValue())));
    }

    Mono<Response<KeyVaultKey>> recoverDeletedKeyWithResponse(String name, Context context) {
        return this.service.recoverDeletedKey(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Recovering deleted key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Recovered deleted key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to recover deleted key - {}", new Object[]{name, error}));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> backupKey(String name) {
        try {
            return this.backupKeyWithResponse(name).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<byte[]>> backupKeyWithResponse(String name) {
        try {
            return FluxUtil.withContext(context -> this.backupKeyWithResponse(name, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<byte[]>> backupKeyWithResponse(String name, Context context) {
        context = context == null ? Context.NONE : context;
        return this.service.backupKey(this.vaultUrl, name, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Backing up key - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Backed up key - {}", new Object[]{name})).doOnError(error -> this.logger.warning("Failed to backup key - {}", new Object[]{name, error})).flatMap(base64URLResponse -> Mono.just((Object)new SimpleResponse(base64URLResponse.getRequest(), base64URLResponse.getStatusCode(), base64URLResponse.getHeaders(), (Object)((KeyBackup)base64URLResponse.getValue()).getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultKey> restoreKeyBackup(byte[] backup) {
        try {
            return this.restoreKeyBackupWithResponse(backup).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultKey>> restoreKeyBackupWithResponse(byte[] backup) {
        try {
            return FluxUtil.withContext(context -> this.restoreKeyBackupWithResponse(backup, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<KeyVaultKey>> restoreKeyBackupWithResponse(byte[] backup, Context context) {
        context = context == null ? Context.NONE : context;
        KeyRestoreRequestParameters parameters = new KeyRestoreRequestParameters().setKeyBackup(backup);
        return this.service.restoreKey(this.vaultUrl, this.apiVersion, parameters, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Attempting to restore key")).doOnSuccess(response -> this.logger.verbose("Restored Key - {}", new Object[]{((KeyVaultKey)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to restore key - {}", new Object[]{error}));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyProperties> listPropertiesOfKeys() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listKeysFirstPage((Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listKeysNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<KeyProperties> listPropertiesOfKeys(Context context) {
        return new PagedFlux(() -> this.listKeysFirstPage(context), continuationToken -> this.listKeysNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<KeyProperties>> listKeysNextPage(String continuationToken, Context context) {
        try {
            return this.service.getKeys(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next keys page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next keys page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next keys page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<KeyProperties>> listKeysFirstPage(Context context) {
        try {
            return this.service.getKeys(this.vaultUrl, 25, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing keys")).doOnSuccess(response -> this.logger.verbose("Listed keys")).doOnError(error -> this.logger.warning("Failed to list keys", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedKey> listDeletedKeys() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listDeletedKeysFirstPage((Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listDeletedKeysNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<DeletedKey> listDeletedKeys(Context context) {
        return new PagedFlux(() -> this.listDeletedKeysFirstPage(context), continuationToken -> this.listDeletedKeysNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<DeletedKey>> listDeletedKeysNextPage(String continuationToken, Context context) {
        try {
            return this.service.getDeletedKeys(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next deleted keys page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next deleted keys page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next deleted keys page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<DeletedKey>> listDeletedKeysFirstPage(Context context) {
        try {
            return this.service.getDeletedKeys(this.vaultUrl, 25, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing deleted keys")).doOnSuccess(response -> this.logger.verbose("Listed deleted keys")).doOnError(error -> this.logger.warning("Failed to list deleted keys", new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyProperties> listPropertiesOfKeyVersions(String name) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listKeyVersionsFirstPage(name, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listKeyVersionsNextPage((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<KeyProperties> listPropertiesOfKeyVersions(String name, Context context) {
        return new PagedFlux(() -> this.listKeyVersionsFirstPage(name, context), continuationToken -> this.listKeyVersionsNextPage((String)continuationToken, context));
    }

    private Mono<PagedResponse<KeyProperties>> listKeyVersionsFirstPage(String name, Context context) {
        try {
            return this.service.getKeyVersions(this.vaultUrl, name, 25, this.apiVersion, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing key versions - {}", new Object[]{name})).doOnSuccess(response -> this.logger.verbose("Listed key versions - {}", new Object[]{name})).doOnError(error -> this.logger.warning(String.format("Failed to list key versions - %s", name), new Object[]{error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<PagedResponse<KeyProperties>> listKeyVersionsNextPage(String continuationToken, Context context) {
        try {
            return this.service.getKeys(this.vaultUrl, continuationToken, ACCEPT_LANGUAGE, CONTENT_TYPE_HEADER_VALUE, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next key versions page - Page {} ", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next key versions page - Page {} ", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next key versions page - Page {} ", new Object[]{continuationToken, error}));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }
}

