/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.security.keyvault.keys.cryptography.AesKw;
import com.azure.security.keyvault.keys.cryptography.CryptoUtil;
import com.azure.security.keyvault.keys.cryptography.ICryptoTransform;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import javax.crypto.NoSuchPaddingException;

class AesKw192
extends AesKw {
    public static final String ALGORITHM_NAME = "A192KW";
    static final int KEY_SIZE_IN_BYTES = 24;

    AesKw192() {
        super(ALGORITHM_NAME);
    }

    @Override
    public ICryptoTransform createEncryptor(byte[] key, byte[] iv, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        CryptoUtil.validate(key, 24);
        return super.createEncryptor(Arrays.copyOfRange(key, 0, 24), iv, provider);
    }

    @Override
    public ICryptoTransform createDecryptor(byte[] key, byte[] iv, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        CryptoUtil.validate(key, 24);
        return super.createDecryptor(Arrays.copyOfRange(key, 0, 24), iv, provider);
    }
}

