/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.keys.cryptography.CryptographyAsyncClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.azure.security.keyvault.keys.cryptography.Strings;
import com.azure.security.keyvault.keys.implementation.KeyVaultCredentialPolicy;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={CryptographyClient.class})
public final class CryptographyClientBuilder {
    final List<HttpPipelinePolicy> policies;
    final Map<String, String> properties;
    private final ClientLogger logger = new ClientLogger(CryptographyClientBuilder.class);
    private static final String AZURE_KEY_VAULT_KEYS = "azure-key-vault-keys.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private TokenCredential credential;
    private HttpPipeline pipeline;
    private JsonWebKey jsonWebKey;
    private String keyId;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private RetryPolicy retryPolicy = new RetryPolicy();
    private Configuration configuration;
    private CryptographyServiceVersion version;

    public CryptographyClientBuilder() {
        this.httpLogOptions = new HttpLogOptions();
        this.policies = new ArrayList<HttpPipelinePolicy>();
        this.properties = CoreUtils.getProperties((String)AZURE_KEY_VAULT_KEYS);
    }

    public CryptographyClient buildClient() {
        return new CryptographyClient(this.buildAsyncClient());
    }

    public CryptographyAsyncClient buildAsyncClient() {
        CryptographyServiceVersion serviceVersion;
        if (this.jsonWebKey == null && Strings.isNullOrEmpty(this.keyId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Json Web Key or jsonWebKey identifier are required to create cryptography client"));
        }
        CryptographyServiceVersion cryptographyServiceVersion = serviceVersion = this.version != null ? this.version : CryptographyServiceVersion.getLatest();
        if (this.pipeline != null) {
            if (this.jsonWebKey != null) {
                return new CryptographyAsyncClient(this.jsonWebKey, this.pipeline, serviceVersion);
            }
            return new CryptographyAsyncClient(this.keyId, this.pipeline, serviceVersion);
        }
        if (this.credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Key Vault credentials are required to build the Cryptography async client"));
        }
        HttpPipeline pipeline = this.setupPipeline();
        if (this.jsonWebKey != null) {
            return new CryptographyAsyncClient(this.jsonWebKey, pipeline, serviceVersion);
        }
        return new CryptographyAsyncClient(this.keyId, pipeline, serviceVersion);
    }

    HttpPipeline setupPipeline() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        policies.add(new UserAgentPolicy(this.httpLogOptions.getApplicationId(), clientName, clientVersion, buildConfiguration));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy);
        policies.add(new KeyVaultCredentialPolicy(this.credential));
        policies.addAll(this.policies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
    }

    TokenCredential getCredential() {
        return this.credential;
    }

    HttpPipeline getPipeline() {
        return this.pipeline;
    }

    CryptographyServiceVersion getServiceVersion() {
        return this.version;
    }

    public CryptographyClientBuilder keyIdentifier(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public CryptographyClientBuilder credential(TokenCredential credential) {
        Objects.requireNonNull(credential);
        this.credential = credential;
        return this;
    }

    public CryptographyClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public CryptographyClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy);
        this.policies.add(policy);
        return this;
    }

    public CryptographyClientBuilder httpClient(HttpClient client) {
        Objects.requireNonNull(client);
        this.httpClient = client;
        return this;
    }

    public CryptographyClientBuilder pipeline(HttpPipeline pipeline) {
        Objects.requireNonNull(pipeline);
        this.pipeline = pipeline;
        return this;
    }

    public CryptographyClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public CryptographyClientBuilder serviceVersion(CryptographyServiceVersion version) {
        this.version = version;
        return this;
    }

    public CryptographyClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "The retry policy cannot be bull");
        this.retryPolicy = retryPolicy;
        return this;
    }
}

