/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.certificates;

import com.azure.security.keyvault.jca.implementation.KeyVaultClient;
import com.azure.security.keyvault.jca.implementation.certificates.AzureCertificates;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class KeyVaultCertificates
implements AzureCertificates {
    private List<String> aliases = new ArrayList<String>();
    private final Map<String, Certificate> certificates = new HashMap<String, Certificate>();
    private final Map<String, Key> certificateKeys = new HashMap<String, Key>();
    private Date lastRefreshTime;
    private KeyVaultClient keyVaultClient;
    private final long refreshInterval;

    public KeyVaultCertificates(long refreshInterval, String keyVaultUri, String tenantId, String clientId, String clientSecret, String managedIdentity) {
        this.refreshInterval = refreshInterval;
        this.updateKeyVaultClient(keyVaultUri, tenantId, clientId, clientSecret, managedIdentity);
    }

    public KeyVaultCertificates(long refreshInterval, KeyVaultClient keyVaultClient) {
        this.refreshInterval = refreshInterval;
        this.keyVaultClient = keyVaultClient;
    }

    public void updateKeyVaultClient(String keyVaultUri, String tenantId, String clientId, String clientSecret, String managedIdentity) {
        this.keyVaultClient = keyVaultUri != null ? new KeyVaultClient(keyVaultUri, tenantId, clientId, clientSecret, managedIdentity) : null;
    }

    boolean certificatesNeedRefresh() {
        if (this.keyVaultClient == null) {
            return false;
        }
        if (this.lastRefreshTime == null) {
            return true;
        }
        return this.refreshInterval > 0L && this.lastRefreshTime.getTime() + this.refreshInterval < new Date().getTime();
    }

    @Override
    public List<String> getAliases() {
        this.refreshCertificatesIfNeeded();
        return this.aliases;
    }

    @Override
    public Map<String, Certificate> getCertificates() {
        this.refreshCertificatesIfNeeded();
        return this.certificates;
    }

    @Override
    public Map<String, Key> getCertificateKeys() {
        this.refreshCertificatesIfNeeded();
        return this.certificateKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCertificatesIfNeeded() {
        if (this.certificatesNeedRefresh()) {
            KeyVaultCertificates keyVaultCertificates = this;
            synchronized (keyVaultCertificates) {
                if (this.certificatesNeedRefresh()) {
                    this.refreshCertificates();
                }
            }
        }
    }

    public synchronized void refreshCertificates() {
        this.aliases = this.keyVaultClient.getAliases();
        this.certificateKeys.clear();
        this.certificates.clear();
        Optional.ofNullable(this.aliases).orElse(Collections.emptyList()).forEach(alias -> {
            Certificate certificate;
            Key key = this.keyVaultClient.getKey((String)alias, null);
            if (!Objects.isNull(key)) {
                this.certificateKeys.put((String)alias, key);
            }
            if (!Objects.isNull(certificate = this.keyVaultClient.getCertificate((String)alias))) {
                this.certificates.put((String)alias, certificate);
            }
        });
        this.lastRefreshTime = new Date();
    }

    public String refreshAndGetAliasByCertificate(Certificate certificate) {
        this.refreshCertificates();
        return this.getCertificates().entrySet().stream().filter(entry -> certificate.equals(entry.getValue())).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    @Override
    public void deleteEntry(String alias) {
        if (this.aliases != null) {
            this.aliases.remove(alias);
        }
        this.certificates.remove(alias);
        this.certificateKeys.remove(alias);
    }
}

