/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.custom.sec;

import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.raw.Mod;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.raw.Nat;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.raw.Nat160;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecP160R2Field {
    static final int[] P = new int[]{-21389, -2, -1, -1, -1};
    private static final int[] PExt = new int[]{457489321, 42778, 1, 0, 0, -42778, -3, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-457489321, -42779, -2, -1, -1, 42777, 2};
    private static final int P4 = -1;
    private static final int PExt9 = -1;
    private static final int PInv33 = 21389;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat160.add((int[])nArray, (int[])nArray2, (int[])nArray3);
        if (n != 0 || nArray3[4] == -1 && Nat160.gte((int[])nArray3, (int[])P)) {
            Nat.add33To(5, 21389, nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.add(10, nArray, nArray2, nArray3);
        if ((n != 0 || nArray3[9] == -1 && Nat.gte(10, nArray3, PExt)) && Nat.addTo(PExtInv.length, PExtInv, nArray3) != 0) {
            Nat.incAt(10, nArray3, PExtInv.length);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        int n = Nat.inc(5, nArray, nArray2);
        if (n != 0 || nArray2[4] == -1 && Nat160.gte((int[])nArray2, (int[])P)) {
            Nat.add33To(5, 21389, nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger bigInteger) {
        int[] nArray = Nat160.fromBigInteger((BigInteger)bigInteger);
        if (nArray[4] == -1 && Nat160.gte((int[])nArray, (int[])P)) {
            Nat160.subFrom((int[])P, (int[])nArray);
        }
        return nArray;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(5, nArray, 0, nArray2);
        } else {
            int n = Nat160.add((int[])nArray, (int[])P, (int[])nArray2);
            Nat.shiftDownBit(5, nArray2, n);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            n |= nArray[i];
        }
        n = n >>> 1 | n & 1;
        return n - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat160.createExt();
        Nat160.mul((int[])nArray, (int[])nArray2, (int[])nArray4);
        SecP160R2Field.reduce((int[])nArray4, (int[])nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat160.mulAddTo((int[])nArray, (int[])nArray2, (int[])nArray3);
        if ((n != 0 || nArray3[9] == -1 && Nat.gte(10, nArray3, PExt)) && Nat.addTo(PExtInv.length, PExtInv, nArray3) != 0) {
            Nat.incAt(10, nArray3, PExtInv.length);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (0 != SecP160R2Field.isZero((int[])nArray)) {
            Nat160.sub((int[])P, (int[])P, (int[])nArray2);
        } else {
            Nat160.sub((int[])P, (int[])nArray, (int[])nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        byte[] byArray = new byte[20];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 5);
        } while (0 == Nat.lessThan(5, nArray, P));
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP160R2Field.random((SecureRandom)secureRandom, (int[])nArray);
        } while (0 != SecP160R2Field.isZero((int[])nArray));
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l = Nat160.mul33Add((int)21389, (int[])nArray, (int)5, (int[])nArray, (int)0, (int[])nArray2, (int)0);
        int n = Nat160.mul33DWordAdd((int)21389, (long)l, (int[])nArray2, (int)0);
        if (n != 0 || nArray2[4] == -1 && Nat160.gte((int[])nArray2, (int[])P)) {
            Nat.add33To(5, 21389, nArray2);
        }
    }

    public static void reduce32(int n, int[] nArray) {
        if (n != 0 && Nat160.mul33WordAdd((int)21389, (int)n, (int[])nArray, (int)0) != 0 || nArray[4] == -1 && Nat160.gte((int[])nArray, (int[])P)) {
            Nat.add33To(5, 21389, nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat160.createExt();
        Nat160.square((int[])nArray, (int[])nArray3);
        SecP160R2Field.reduce((int[])nArray3, (int[])nArray2);
    }

    public static void squareN(int[] nArray, int n, int[] nArray2) {
        int[] nArray3 = Nat160.createExt();
        Nat160.square((int[])nArray, (int[])nArray3);
        SecP160R2Field.reduce((int[])nArray3, (int[])nArray2);
        while (--n > 0) {
            Nat160.square((int[])nArray2, (int[])nArray3);
            SecP160R2Field.reduce((int[])nArray3, (int[])nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat160.sub((int[])nArray, (int[])nArray2, (int[])nArray3);
        if (n != 0) {
            Nat.sub33From(5, 21389, nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = Nat.sub(10, nArray, nArray2, nArray3);
        if (n != 0 && Nat.subFrom(PExtInv.length, PExtInv, nArray3) != 0) {
            Nat.decAt(10, nArray3, PExtInv.length);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        int n = Nat.shiftUpBit(5, nArray, 0, nArray2);
        if (n != 0 || nArray2[4] == -1 && Nat160.gte((int[])nArray2, (int[])P)) {
            Nat.add33To(5, 21389, nArray2);
        }
    }
}

