/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.certificates;

import com.azure.security.keyvault.jca.implementation.certificates.AzureCertificates;
import com.azure.security.keyvault.jca.implementation.utils.CertificateUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClasspathCertificates
implements AzureCertificates {
    private static final Logger LOGGER = Logger.getLogger(ClasspathCertificates.class.getName());
    private final List<String> aliases = new ArrayList<String>();
    private final Map<String, Certificate> certificates = new HashMap<String, Certificate>();
    private final Map<String, Certificate[]> certificateChains = new HashMap<String, Certificate[]>();
    private final Map<String, Key> certificateKeys = new HashMap<String, Key>();

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public Map<String, Certificate> getCertificates() {
        return this.certificates;
    }

    @Override
    public Map<String, Certificate[]> getCertificateChains() {
        return this.certificateChains;
    }

    @Override
    public Map<String, Key> getCertificateKeys() {
        return this.certificateKeys;
    }

    public void setCertificateEntry(String alias, Certificate certificate) {
        if (!this.aliases.contains(alias)) {
            this.aliases.add(alias);
            this.certificates.put(alias, certificate);
            this.certificateChains.put(alias, new Certificate[]{certificate});
        }
    }

    @Override
    public void deleteEntry(String alias) {
        this.aliases.remove(alias);
        this.certificates.remove(alias);
        this.certificateKeys.remove(alias);
        this.certificateChains.remove(alias);
    }

    public void loadCertificatesFromClasspath() {
        try {
            String[] filenames;
            for (String filename : filenames = this.getFilenames("/keyvault")) {
                try (InputStream inputStream = this.getClass().getResourceAsStream("/keyvault/" + filename);){
                    String alias = filename;
                    if (alias == null) continue;
                    if (alias.lastIndexOf(46) != -1) {
                        alias = alias.substring(0, alias.lastIndexOf(46));
                    }
                    try {
                        Certificate certificate = CertificateUtil.loadX509CertificateFromFile(inputStream);
                        this.setCertificateEntry(alias, certificate);
                        this.certificateChains.put(alias, CertificateUtil.loadX509CertificatesFromFile(inputStream));
                        LOGGER.log(Level.INFO, "Side loaded certificate: {0} from: {1}", new Object[]{alias, filename});
                    }
                    catch (CertificateException e) {
                        LOGGER.log(Level.WARNING, "Unable to side-load certificate from: " + filename, e);
                    }
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Unable to determine certificates to side-load", ioe);
        }
    }

    private String[] getFilenames(String path) throws IOException {
        ArrayList<String> filenames;
        block12: {
            filenames = new ArrayList<String>();
            try (InputStream in = this.getClass().getResourceAsStream(path);){
                if (Objects.isNull(in)) break block12;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    String resource;
                    while ((resource = br.readLine()) != null) {
                        filenames.add(resource);
                    }
                }
            }
        }
        return filenames.toArray(new String[0]);
    }
}

