/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation;

import com.azure.security.keyvault.certificates.implementation.CertificateRequestAttributes;
import com.azure.security.keyvault.certificates.implementation.IssuerParameters;
import com.azure.security.keyvault.certificates.implementation.KeyProperties;
import com.azure.security.keyvault.certificates.implementation.LifetimeActionRequest;
import com.azure.security.keyvault.certificates.implementation.SecretProperties;
import com.azure.security.keyvault.certificates.implementation.X509CertificateProperties;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.LifetimeAction;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public final class CertificatePolicyRequest {
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="key_props")
    private KeyProperties keyProperties;
    @JsonProperty(value="secret_props")
    private SecretProperties secretProperties;
    @JsonProperty(value="x509_props")
    private X509CertificateProperties x509CertificateProperties;
    @JsonProperty(value="lifetime_actions")
    private List<LifetimeActionRequest> lifetimeActionRequests;
    @JsonProperty(value="issuer")
    private IssuerParameters issuerParameters;
    @JsonProperty(value="attributes")
    private CertificateRequestAttributes attributes;

    public CertificatePolicyRequest(CertificatePolicy certificatePolicy) {
        this.keyProperties = new KeyProperties(certificatePolicy);
        this.x509CertificateProperties = new X509CertificateProperties(certificatePolicy);
        this.secretProperties = certificatePolicy.getContentType() != null ? new SecretProperties(certificatePolicy.getContentType().toString()) : null;
        this.issuerParameters = new IssuerParameters(certificatePolicy);
        this.lifetimeActionRequests = certificatePolicy.getLifetimeActions() != null ? this.parseLifeTimeActions(certificatePolicy.getLifetimeActions()) : null;
        this.attributes = new CertificateRequestAttributes().enabled(certificatePolicy.isEnabled());
    }

    private List<LifetimeActionRequest> parseLifeTimeActions(List<LifetimeAction> input) {
        ArrayList<LifetimeActionRequest> output = new ArrayList<LifetimeActionRequest>();
        for (LifetimeAction action : input) {
            output.add(new LifetimeActionRequest(action));
        }
        return output;
    }

    public String id() {
        return this.id;
    }

    public KeyProperties keyProperties() {
        return this.keyProperties;
    }

    public CertificatePolicyRequest keyProperties(KeyProperties keyProperties) {
        this.keyProperties = keyProperties;
        return this;
    }

    public SecretProperties secretProperties() {
        return this.secretProperties;
    }

    public CertificatePolicyRequest secretProperties(SecretProperties secretProperties) {
        this.secretProperties = secretProperties;
        return this;
    }

    public X509CertificateProperties x509CertificateProperties() {
        return this.x509CertificateProperties;
    }

    public CertificatePolicyRequest x509CertificateProperties(X509CertificateProperties x509CertificateProperties) {
        this.x509CertificateProperties = x509CertificateProperties;
        return this;
    }

    public List<LifetimeActionRequest> lifetimeActions() {
        return this.lifetimeActionRequests;
    }

    public CertificatePolicyRequest lifetimeActions(List<LifetimeActionRequest> lifetimeActionRequests) {
        this.lifetimeActionRequests = lifetimeActionRequests;
        return this;
    }

    public IssuerParameters issuerParameters() {
        return this.issuerParameters;
    }

    public CertificatePolicyRequest issuerParameters(IssuerParameters issuerParameters) {
        this.issuerParameters = issuerParameters;
        return this;
    }

    public CertificateRequestAttributes attributes() {
        return this.attributes;
    }

    public CertificatePolicyRequest attributes(CertificateRequestAttributes attributes) {
        this.attributes = attributes;
        return this;
    }
}

