/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.models;

import com.azure.security.keyvault.certificates.models.CertificateContentType;
import com.azure.security.keyvault.certificates.models.CertificateKeyCurveName;
import com.azure.security.keyvault.certificates.models.CertificateKeyType;
import com.azure.security.keyvault.certificates.models.CertificateKeyUsage;
import com.azure.security.keyvault.certificates.models.CertificatePolicyAction;
import com.azure.security.keyvault.certificates.models.LifetimeAction;
import com.azure.security.keyvault.certificates.models.SubjectAlternativeNames;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class CertificatePolicy {
    @JsonProperty(value="subject")
    private String subject;
    @JsonProperty(value="sans")
    private SubjectAlternativeNames subjectAlternativeNames;
    @JsonProperty(value="validity_months")
    private Integer validityInMonths;
    private List<LifetimeAction> lifetimeActions;
    @JsonProperty(value="name")
    private String issuerName;
    @JsonProperty(value="cty")
    private String certificateType;
    @JsonProperty(value="cert_transparency")
    private Boolean certificateTransparent;
    private CertificateContentType contentType;
    private OffsetDateTime createdOn;
    private OffsetDateTime updatedOn;
    private Boolean enabled;
    @JsonProperty(value="exportable")
    private Boolean exportable;
    @JsonProperty(value="kty")
    private CertificateKeyType keyType;
    @JsonProperty(value="key_size")
    private Integer keySize;
    @JsonProperty(value="reuse_key")
    private Boolean keyReusable;
    @JsonProperty(value="crv")
    private CertificateKeyCurveName keyCurveName;
    @JsonProperty(value="key_usage")
    private List<CertificateKeyUsage> keyUsage;
    @JsonProperty(value="ekus")
    private List<String> enhancedKeyUsage;

    public CertificatePolicy(String issuerName, String subject) {
        this.issuerName = issuerName;
        this.subject = subject;
    }

    public CertificatePolicy(String issuerName, SubjectAlternativeNames subjectAlternativeNames) {
        this.issuerName = issuerName;
        this.subjectAlternativeNames = subjectAlternativeNames;
    }

    public CertificatePolicy(String issuerName, String subject, SubjectAlternativeNames subjectAlternativeNames) {
        this.issuerName = issuerName;
        this.subject = subject;
        this.subjectAlternativeNames = subjectAlternativeNames;
    }

    CertificatePolicy() {
    }

    public List<CertificateKeyUsage> getKeyUsage() {
        return this.keyUsage;
    }

    public CertificatePolicy setKeyUsage(CertificateKeyUsage ... keyUsage) {
        this.keyUsage = Arrays.asList(keyUsage);
        return this;
    }

    public List<String> getEnhancedKeyUsage() {
        return this.enhancedKeyUsage;
    }

    public CertificatePolicy setEnhancedKeyUsage(List<String> ekus) {
        this.enhancedKeyUsage = ekus;
        return this;
    }

    public Boolean isExportable() {
        return this.exportable;
    }

    public CertificatePolicy setExportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    public CertificateKeyType getKeyType() {
        return this.keyType;
    }

    public CertificatePolicy setKeyType(CertificateKeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public Boolean isKeyReusable() {
        return this.keyReusable;
    }

    public CertificatePolicy setKeyReusable(Boolean keyReusable) {
        this.keyReusable = keyReusable;
        return this;
    }

    public CertificateKeyCurveName getKeyCurveName() {
        return this.keyCurveName;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public CertificatePolicy setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public CertificateContentType getContentType() {
        return this.contentType;
    }

    public CertificatePolicy setContentType(CertificateContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public SubjectAlternativeNames getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public CertificatePolicy setSubjectAlternativeNames(SubjectAlternativeNames subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    public CertificatePolicy setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public CertificatePolicy setValidityInMonths(Integer validityInMonths) {
        this.validityInMonths = validityInMonths;
        return this;
    }

    public CertificatePolicy setKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    public CertificatePolicy setKeyCurveName(CertificateKeyCurveName keyCurveName) {
        this.keyCurveName = keyCurveName;
        return this;
    }

    public CertificatePolicy setCertificateType(String certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    public CertificatePolicy setCertificateTransparent(Boolean certificateTransparent) {
        this.certificateTransparent = certificateTransparent;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public Integer getValidityInMonths() {
        return this.validityInMonths;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public String getCertificateType() {
        return this.certificateType;
    }

    public Boolean isCertificateTransparent() {
        return this.certificateTransparent;
    }

    public CertificatePolicy setLifetimeActions(LifetimeAction ... actions) {
        this.lifetimeActions = Arrays.asList(actions);
        return this;
    }

    public List<LifetimeAction> getLifetimeActions() {
        return this.lifetimeActions;
    }

    public static CertificatePolicy getDefault() {
        return new CertificatePolicy("Self", "CN=DefaultPolicy");
    }

    @JsonProperty(value="key_props")
    private void unpackKeyProperties(Map<String, Object> keyProps) {
        this.keyType = CertificateKeyType.fromString((String)keyProps.get("kty"));
        this.keySize = (Integer)keyProps.get("key_size");
        this.exportable = (Boolean)keyProps.get("exportable");
        this.keyReusable = (Boolean)keyProps.get("reuse_key");
        this.keyCurveName = keyProps.containsKey("crv") ? CertificateKeyCurveName.fromString((String)keyProps.get("crv")) : null;
    }

    @JsonProperty(value="x509_props")
    private void unpackX509Properties(Map<String, Object> x509Props) {
        this.validityInMonths = (Integer)x509Props.get("validity_months");
        this.subject = (String)x509Props.get("subject");
        this.enhancedKeyUsage = x509Props.containsKey("ekus") ? this.parseEnhancedKeyUsage((List)x509Props.get("ekus")) : null;
        this.keyUsage = x509Props.containsKey("key_usage") ? this.parseKeyUsage((List)x509Props.get("key_usage")) : null;
    }

    private List<CertificateKeyUsage> parseKeyUsage(List<Object> keyUsages) {
        ArrayList<CertificateKeyUsage> output = new ArrayList<CertificateKeyUsage>();
        for (Object keyUsage : keyUsages) {
            CertificateKeyUsage type = CertificateKeyUsage.fromString((String)keyUsage);
            output.add(type);
        }
        return output;
    }

    private List<String> parseEnhancedKeyUsage(List<Object> keyUsages) {
        ArrayList<String> output = new ArrayList<String>();
        for (Object keyUsage : keyUsages) {
            output.add((String)keyUsage);
        }
        return output;
    }

    @JsonProperty(value="secret_props")
    private void unpackSecretProperties(Map<String, Object> secretProps) {
        this.contentType = secretProps.containsKey("contentType") ? CertificateContentType.fromString((String)secretProps.get("contentType")) : null;
    }

    @JsonProperty(value="issuer")
    private void unpackIssuerProperties(Map<String, Object> issuerProps) {
        this.issuerName = (String)issuerProps.get("name");
        this.certificateType = (String)issuerProps.get("cty");
        this.certificateTransparent = (Boolean)issuerProps.get("cert_transparency");
    }

    @JsonProperty(value="lifetime_actions")
    private void unpackLifeTimeActions(List<Object> lifetimeActions) {
        ArrayList<LifetimeAction> actions = new ArrayList<LifetimeAction>();
        for (Object action : lifetimeActions) {
            Map map = (Map)action;
            Integer lifetimePercentageTrigger = null;
            Integer daysBeforeExpiryTrigger = null;
            CertificatePolicyAction actionType = null;
            if (map.containsKey("trigger")) {
                Map trigger = (Map)map.get("trigger");
                lifetimePercentageTrigger = trigger.containsKey("lifetime_percentage") ? (Integer)trigger.get("lifetime_percentage") : null;
                Integer n = daysBeforeExpiryTrigger = trigger.containsKey("days_before_expiry") ? (Integer)trigger.get("days_before_expiry") : null;
            }
            if (map.containsKey("action")) {
                Map lifetimeAction = (Map)map.get("action");
                actionType = lifetimeAction.containsKey("action_type") ? CertificatePolicyAction.fromString((String)lifetimeAction.get("action_type")) : null;
            }
            actions.add(new LifetimeAction(actionType).setLifetimePercentage(lifetimePercentageTrigger).setDaysBeforeExpiry(daysBeforeExpiryTrigger));
        }
        this.lifetimeActions = actions;
    }

    @JsonProperty(value="attributes")
    private void unpackAttributes(Map<String, Object> attributes) {
        this.enabled = (Boolean)attributes.get("enabled");
        this.createdOn = this.epochToOffsetDateTime(attributes.get("created"));
        this.updatedOn = this.epochToOffsetDateTime(attributes.get("updated"));
    }

    private OffsetDateTime epochToOffsetDateTime(Object epochValue) {
        if (epochValue != null) {
            Instant instant = Instant.ofEpochMilli(((Number)epochValue).longValue() * 1000L);
            return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        return null;
    }
}

