/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.ImportCertificateOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

class CertificateRequestAttributes {
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="nbf")
    private Long notBefore;
    @JsonProperty(value="exp")
    private Long expires;
    @JsonProperty(value="created", access=JsonProperty.Access.WRITE_ONLY)
    private Long created;
    @JsonProperty(value="updated", access=JsonProperty.Access.WRITE_ONLY)
    private Long updated;

    CertificateRequestAttributes(CertificateProperties certificateProperties) {
        if (certificateProperties.getNotBefore() != null) {
            this.notBefore = certificateProperties.getNotBefore().toEpochSecond();
        }
        if (certificateProperties.getExpiresOn() != null) {
            this.expires = certificateProperties.getExpiresOn().toEpochSecond();
        }
        this.enabled = certificateProperties.isEnabled();
    }

    CertificateRequestAttributes(ImportCertificateOptions importCertificateOptions) {
        this.enabled = importCertificateOptions.isEnabled();
    }

    CertificateRequestAttributes() {
    }

    public Boolean enabled() {
        return this.enabled;
    }

    CertificateRequestAttributes enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    OffsetDateTime notBefore() {
        if (this.notBefore == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.notBefore * 1000L), ZoneOffset.UTC);
    }

    CertificateRequestAttributes notBefore(OffsetDateTime notBefore) {
        this.notBefore = notBefore == null ? null : Long.valueOf(OffsetDateTime.ofInstant(notBefore.toInstant(), ZoneOffset.UTC).toEpochSecond());
        return this;
    }

    OffsetDateTime expires() {
        if (this.expires == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.expires * 1000L), ZoneOffset.UTC);
    }

    CertificateRequestAttributes expires(OffsetDateTime expires) {
        this.expires = expires == null ? null : Long.valueOf(OffsetDateTime.ofInstant(expires.toInstant(), ZoneOffset.UTC).toEpochSecond());
        return this;
    }

    OffsetDateTime created() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.created * 1000L), ZoneOffset.UTC);
    }

    OffsetDateTime updated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.updated * 1000L), ZoneOffset.UTC);
    }
}

