/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.certificates.CertificateAsyncClient;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.certificates.CertificateService;
import com.azure.security.keyvault.certificates.models.CertificateContact;
import com.azure.security.keyvault.certificates.models.CertificateIssuer;
import com.azure.security.keyvault.certificates.models.CertificateOperation;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.DeletedCertificate;
import com.azure.security.keyvault.certificates.models.ImportCertificateOptions;
import com.azure.security.keyvault.certificates.models.IssuerProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import com.azure.security.keyvault.certificates.models.MergeCertificateOptions;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClient(builder=CertificateClientBuilder.class, serviceInterfaces={CertificateService.class})
public final class CertificateClient {
    private final CertificateAsyncClient client;

    CertificateClient(CertificateAsyncClient client) {
        this.client = client;
    }

    public String getVaultUrl() {
        return this.client.getVaultUrl();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy, Boolean isEnabled, Map<String, String> tags) {
        return this.client.beginCreateCertificate(certificateName, policy, isEnabled, tags).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> beginCreateCertificate(String certificateName, CertificatePolicy policy) {
        return this.client.beginCreateCertificate(certificateName, policy).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<CertificateOperation, KeyVaultCertificateWithPolicy> getCertificateOperation(String certificateName) {
        return this.client.getCertificateOperation(certificateName).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy getCertificate(String certificateName) {
        return (KeyVaultCertificateWithPolicy)this.getCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> getCertificateWithResponse(String certificateName, Context context) {
        return (Response)this.client.getCertificateWithResponse(certificateName, "", context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificate> getCertificateVersionWithResponse(String certificateName, String version, Context context) {
        return (Response)this.client.getCertificateVersionWithResponse(certificateName, version, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificate getCertificateVersion(String certificateName, String version) {
        return (KeyVaultCertificate)this.getCertificateVersionWithResponse(certificateName, version, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificate updateCertificateProperties(CertificateProperties properties) {
        return (KeyVaultCertificate)this.updateCertificatePropertiesWithResponse(properties, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificate> updateCertificatePropertiesWithResponse(CertificateProperties properties, Context context) {
        return (Response)this.client.updateCertificatePropertiesWithResponse(properties, context).block();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedCertificate, Void> beginDeleteCertificate(String certificateName) {
        return this.client.beginDeleteCertificate(certificateName).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedCertificate getDeletedCertificate(String certificateName) {
        return (DeletedCertificate)this.getDeletedCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedCertificate> getDeletedCertificateWithResponse(String certificateName, Context context) {
        return (Response)this.client.getDeletedCertificateWithResponse(certificateName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedCertificate(String certificateName) {
        this.purgeDeletedCertificateWithResponse(certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedCertificateWithResponse(String certificateName, Context context) {
        return (Response)this.client.purgeDeletedCertificateWithResponse(certificateName, context).block();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultCertificateWithPolicy, Void> beginRecoverDeletedCertificate(String certificateName) {
        return this.client.beginRecoverDeletedCertificate(certificateName).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupCertificate(String certificateName) {
        return (byte[])this.backupCertificateWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupCertificateWithResponse(String certificateName, Context context) {
        return (Response)this.client.backupCertificateWithResponse(certificateName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy restoreCertificateBackup(byte[] backup) {
        return (KeyVaultCertificateWithPolicy)this.restoreCertificateBackupWithResponse(backup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> restoreCertificateBackupWithResponse(byte[] backup, Context context) {
        return (Response)this.client.restoreCertificateBackupWithResponse(backup, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificates() {
        return new PagedIterable(this.client.listPropertiesOfCertificates(false, Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificates(boolean includePending, Context context) {
        return new PagedIterable(this.client.listPropertiesOfCertificates(includePending, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificate> listDeletedCertificates() {
        return this.listDeletedCertificates(false, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedCertificate> listDeletedCertificates(boolean includePending, Context context) {
        return new PagedIterable(this.client.listDeletedCertificates(includePending, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName) {
        return this.listPropertiesOfCertificateVersions(certificateName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateProperties> listPropertiesOfCertificateVersions(String certificateName, Context context) {
        return new PagedIterable(this.client.listPropertiesOfCertificateVersions(certificateName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificatePolicy getCertificatePolicy(String certificateName) {
        return (CertificatePolicy)this.getCertificatePolicyWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificatePolicy> getCertificatePolicyWithResponse(String certificateName, Context context) {
        return (Response)this.client.getCertificatePolicyWithResponse(certificateName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificatePolicy updateCertificatePolicy(String certificateName, CertificatePolicy policy) {
        return (CertificatePolicy)this.updateCertificatePolicyWithResponse(certificateName, policy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificatePolicy> updateCertificatePolicyWithResponse(String certificateName, CertificatePolicy policy, Context context) {
        return (Response)this.client.updateCertificatePolicyWithResponse(certificateName, policy, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer createIssuer(CertificateIssuer issuer) {
        return (CertificateIssuer)this.createIssuerWithResponse(issuer, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> createIssuerWithResponse(CertificateIssuer issuer, Context context) {
        return (Response)this.client.createIssuerWithResponse(issuer, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> getIssuerWithResponse(String issuerName, Context context) {
        return (Response)this.client.getIssuerWithResponse(issuerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer getIssuer(String issuerName) {
        return (CertificateIssuer)this.getIssuerWithResponse(issuerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> deleteIssuerWithResponse(String issuerName, Context context) {
        return (Response)this.client.deleteIssuerWithResponse(issuerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer deleteIssuer(String issuerName) {
        return (CertificateIssuer)this.deleteIssuerWithResponse(issuerName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IssuerProperties> listPropertiesOfIssuers() {
        return this.listPropertiesOfIssuers(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IssuerProperties> listPropertiesOfIssuers(Context context) {
        return new PagedIterable(this.client.listPropertiesOfIssuers(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateIssuer updateIssuer(CertificateIssuer issuer) {
        return (CertificateIssuer)this.updateIssuerWithResponse(issuer, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateIssuer> updateIssuerWithResponse(CertificateIssuer issuer, Context context) {
        return (Response)this.client.updateIssuerWithResponse(issuer, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> setContacts(List<CertificateContact> contacts) {
        return this.setContacts(contacts, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> setContacts(List<CertificateContact> contacts, Context context) {
        return new PagedIterable(this.client.setContacts(contacts, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> listContacts() {
        return this.listContacts(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> listContacts(Context context) {
        return new PagedIterable(this.client.listContacts(context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> deleteContacts() {
        return this.deleteContacts(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CertificateContact> deleteContacts(Context context) {
        return new PagedIterable(this.client.deleteContacts(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation deleteCertificateOperation(String certificateName) {
        return (CertificateOperation)this.deleteCertificateOperationWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> deleteCertificateOperationWithResponse(String certificateName, Context context) {
        return (Response)this.client.deleteCertificateOperationWithResponse(certificateName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CertificateOperation cancelCertificateOperation(String certificateName) {
        return (CertificateOperation)this.cancelCertificateOperationWithResponse(certificateName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CertificateOperation> cancelCertificateOperationWithResponse(String certificateName, Context context) {
        return (Response)this.client.cancelCertificateOperationWithResponse(certificateName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy mergeCertificate(MergeCertificateOptions mergeCertificateOptions) {
        return (KeyVaultCertificateWithPolicy)this.mergeCertificateWithResponse(mergeCertificateOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> mergeCertificateWithResponse(MergeCertificateOptions mergeCertificateOptions, Context context) {
        Objects.requireNonNull(mergeCertificateOptions, "'mergeCertificateOptions' cannot be null.");
        return (Response)this.client.mergeCertificateWithResponse(mergeCertificateOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultCertificateWithPolicy importCertificate(ImportCertificateOptions importCertificateOptions) {
        return (KeyVaultCertificateWithPolicy)this.importCertificateWithResponse(importCertificateOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultCertificateWithPolicy> importCertificateWithResponse(ImportCertificateOptions importCertificateOptions, Context context) {
        return (Response)this.client.importCertificateWithResponse(importCertificateOptions, context).block();
    }
}

