/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.administration.KeyVaultAdministrationUtil;
import com.azure.security.keyvault.administration.KeyVaultSettingsClientBuilder;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationClientImpl;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationUtils;
import com.azure.security.keyvault.administration.implementation.models.Setting;
import com.azure.security.keyvault.administration.implementation.models.SettingsListResult;
import com.azure.security.keyvault.administration.implementation.models.UpdateSettingRequest;
import com.azure.security.keyvault.administration.models.KeyVaultGetSettingsResult;
import com.azure.security.keyvault.administration.models.KeyVaultSetting;
import com.azure.security.keyvault.administration.models.KeyVaultSettingType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=KeyVaultSettingsClientBuilder.class, isAsync=true, serviceInterfaces={KeyVaultAdministrationClientImpl.KeyVaultAdministrationClientService.class})
public final class KeyVaultSettingsAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultSettingsAsyncClient.class);
    private final KeyVaultAdministrationClientImpl implClient;

    KeyVaultSettingsAsyncClient(KeyVaultAdministrationClientImpl implClient) {
        this.implClient = implClient;
    }

    HttpPipeline getHttpPipeline() {
        return this.implClient.getHttpPipeline();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSetting> updateSetting(KeyVaultSetting setting) {
        Objects.requireNonNull(setting, String.format("%s cannot be null.", "'setting'"));
        try {
            String settingValue = null;
            if (setting.getType() == KeyVaultSettingType.BOOLEAN) {
                settingValue = Boolean.toString(setting.asBoolean());
            }
            return this.implClient.updateSettingWithResponseAsync(setting.getName(), BinaryData.fromObject((Object)new UpdateSettingRequest(settingValue)), KeyVaultAdministrationUtil.EMPTY_OPTIONS).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)((BinaryData)response.getValue()).toObject(Setting.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultSetting>> updateSettingWithResponse(KeyVaultSetting setting) {
        Objects.requireNonNull(setting, String.format("%s cannot be null.", "'setting'"));
        try {
            String settingValue = null;
            if (setting.getType() == KeyVaultSettingType.BOOLEAN) {
                settingValue = Boolean.toString(setting.asBoolean());
            }
            return this.implClient.updateSettingWithResponseAsync(setting.getName(), BinaryData.fromObject((Object)new UpdateSettingRequest(settingValue)), KeyVaultAdministrationUtil.EMPTY_OPTIONS).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> new SimpleResponse(response, (Object)KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)((BinaryData)response.getValue()).toObject(Setting.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultSetting> getSetting(String name) {
        try {
            return this.implClient.getSettingWithResponseAsync(name, KeyVaultAdministrationUtil.EMPTY_OPTIONS).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)((BinaryData)response.getValue()).toObject(Setting.class)));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultSetting>> getSettingWithResponse(String name) {
        try {
            return this.implClient.getSettingWithResponseAsync(name, KeyVaultAdministrationUtil.EMPTY_OPTIONS).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> new SimpleResponse(response, (Object)KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)((BinaryData)response.getValue()).toObject(Setting.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultGetSettingsResult> getSettings() {
        try {
            return this.implClient.getSettingsWithResponseAsync(KeyVaultAdministrationUtil.EMPTY_OPTIONS).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> {
                List<KeyVaultSetting> keyVaultSettings = ((SettingsListResult)((BinaryData)response.getValue()).toObject(SettingsListResult.class)).getSettings().stream().map(KeyVaultSettingsAsyncClient::transformToKeyVaultSetting).collect(Collectors.toList());
                return new KeyVaultGetSettingsResult(keyVaultSettings);
            });
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultGetSettingsResult>> getSettingsWithResponse() {
        try {
            return this.implClient.getSettingsWithResponseAsync(KeyVaultAdministrationUtil.EMPTY_OPTIONS).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> {
                List<KeyVaultSetting> keyVaultSettings = ((SettingsListResult)((BinaryData)response.getValue()).toObject(SettingsListResult.class)).getSettings().stream().map(KeyVaultSettingsAsyncClient::transformToKeyVaultSetting).collect(Collectors.toList());
                return new SimpleResponse(response, (Object)new KeyVaultGetSettingsResult(keyVaultSettings));
            });
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    static KeyVaultSetting transformToKeyVaultSetting(Setting setting) {
        if (KeyVaultSettingType.BOOLEAN.toString().equalsIgnoreCase(setting.getType().toString())) {
            return new KeyVaultSetting(setting.getName(), Boolean.parseBoolean(setting.getValue()));
        }
        throw new IllegalArgumentException(String.format("Could not deserialize setting with name '%s'. Type '%s' is not supported.", new Object[]{setting.getName(), setting.getType()}));
    }
}

