/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.administration.models.KeyVaultSettingType;

public final class KeyVaultSetting {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultSetting.class);
    private final String name;
    private final Object value;
    private final KeyVaultSettingType type;

    public KeyVaultSetting(String name, boolean value) {
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The 'name' parameter cannot be null or empty"));
        }
        this.name = name;
        this.value = value;
        this.type = KeyVaultSettingType.BOOLEAN;
    }

    public String getName() {
        return this.name;
    }

    public boolean asBoolean() {
        if (this.type != KeyVaultSettingType.BOOLEAN) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException(String.format("Cannot get setting value as %s from setting value of type %s", new Object[]{KeyVaultSettingType.BOOLEAN, this.getType()})));
        }
        return (Boolean)this.value;
    }

    public KeyVaultSettingType getType() {
        return this.type;
    }
}

