/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.security.keyvault.administration.KeyVaultAdministrationServiceVersion;
import com.azure.security.keyvault.administration.KeyVaultAdministrationUtil;
import com.azure.security.keyvault.administration.KeyVaultBackupClientBuilder;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationClientImpl;
import com.azure.security.keyvault.administration.implementation.models.FullBackupOperation;
import com.azure.security.keyvault.administration.implementation.models.PreBackupOperationParameters;
import com.azure.security.keyvault.administration.implementation.models.PreRestoreOperationParameters;
import com.azure.security.keyvault.administration.implementation.models.RestoreOperation;
import com.azure.security.keyvault.administration.implementation.models.RestoreOperationParameters;
import com.azure.security.keyvault.administration.implementation.models.SASTokenParameter;
import com.azure.security.keyvault.administration.implementation.models.SelectiveKeyRestoreOperation;
import com.azure.security.keyvault.administration.implementation.models.SelectiveKeyRestoreOperationParameters;
import com.azure.security.keyvault.administration.models.KeyVaultBackupOperation;
import com.azure.security.keyvault.administration.models.KeyVaultRestoreOperation;
import com.azure.security.keyvault.administration.models.KeyVaultRestoreResult;
import com.azure.security.keyvault.administration.models.KeyVaultSelectiveKeyRestoreOperation;
import com.azure.security.keyvault.administration.models.KeyVaultSelectiveKeyRestoreResult;
import java.net.URL;
import java.time.Duration;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=KeyVaultBackupClientBuilder.class, isAsync=true)
public final class KeyVaultBackupAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultBackupAsyncClient.class);
    private static final Duration DEFAULT_POLLING_INTERVAL = Duration.ofSeconds(1L);
    private final KeyVaultAdministrationClientImpl clientImpl;
    private final String vaultUrl;
    private final HttpPipeline pipeline;

    Duration getDefaultPollingInterval() {
        return DEFAULT_POLLING_INTERVAL;
    }

    KeyVaultBackupAsyncClient(URL vaultUrl, HttpPipeline httpPipeline, KeyVaultAdministrationServiceVersion serviceVersion) {
        Objects.requireNonNull(vaultUrl, "Azure Key Vault endpoint url is required.");
        this.vaultUrl = vaultUrl.toString();
        this.pipeline = httpPipeline;
        this.clientImpl = new KeyVaultAdministrationClientImpl(httpPipeline, this.vaultUrl, serviceVersion);
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultBackupOperation, Void> beginPreBackup(String blobStorageUrl, String sasToken) {
        if (blobStorageUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'blobStorageUrl'")));
        }
        return new PollerFlux(this.getDefaultPollingInterval(), this.preBackupActivationOperation(blobStorageUrl, sasToken), this.backupPollOperation(), (pollingContext, firstResponse) -> Mono.error((Throwable)LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), pollingContext -> Mono.empty());
    }

    Mono<Response<KeyVaultBackupOperation>> preBackupWithResponse(String blobStorageUrl, String sasToken, Context context) {
        PreBackupOperationParameters preBackupOperationParameters = new PreBackupOperationParameters().setStorageResourceUri(blobStorageUrl).setToken(sasToken).setUseManagedIdentity(sasToken == null);
        try {
            return this.clientImpl.preFullBackupWithResponseAsync(BinaryData.fromObject((Object)preBackupOperationParameters), new RequestOptions().setContext(context)).map(backupOperationResponse -> new SimpleResponse(backupOperationResponse.getRequest(), backupOperationResponse.getStatusCode(), backupOperationResponse.getHeaders(), (Object)((KeyVaultBackupOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((FullBackupOperation)((BinaryData)backupOperationResponse.getValue()).toObject(FullBackupOperation.class)))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    private Function<PollingContext<KeyVaultBackupOperation>, Mono<KeyVaultBackupOperation>> preBackupActivationOperation(String blobStorageUrl, String sasToken) {
        return pollingContext -> {
            try {
                return FluxUtil.withContext(context -> this.preBackupWithResponse(blobStorageUrl, sasToken, (Context)context)).map(Response::getValue);
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        };
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultBackupOperation, String> beginBackup(String blobStorageUrl, String sasToken) {
        if (blobStorageUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'blobStorageUrl'")));
        }
        return new PollerFlux(this.getDefaultPollingInterval(), this.backupActivationOperation(blobStorageUrl, sasToken), this.backupPollOperation(), (pollingContext, firstResponse) -> Mono.error((Throwable)LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), this.backupFetchOperation());
    }

    Mono<Response<KeyVaultBackupOperation>> backupWithResponse(String blobStorageUrl, String sasToken, Context context) {
        SASTokenParameter sasTokenParameter = new SASTokenParameter(blobStorageUrl).setToken(sasToken).setUseManagedIdentity(sasToken == null);
        try {
            return this.clientImpl.fullBackupWithResponseAsync(BinaryData.fromObject((Object)sasTokenParameter), new RequestOptions().setContext(context)).map(backupOperationResponse -> new SimpleResponse(backupOperationResponse.getRequest(), backupOperationResponse.getStatusCode(), backupOperationResponse.getHeaders(), (Object)((KeyVaultBackupOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((FullBackupOperation)((BinaryData)backupOperationResponse.getValue()).toObject(FullBackupOperation.class)))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    private Function<PollingContext<KeyVaultBackupOperation>, Mono<KeyVaultBackupOperation>> backupActivationOperation(String blobStorageUrl, String sasToken) {
        return pollingContext -> {
            try {
                return FluxUtil.withContext(context -> this.backupWithResponse(blobStorageUrl, sasToken, (Context)context)).map(Response::getValue);
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        };
    }

    private Function<PollingContext<KeyVaultBackupOperation>, Mono<PollResponse<KeyVaultBackupOperation>>> backupPollOperation() {
        return pollingContext -> {
            try {
                PollResponse pollResponse = pollingContext.getLatestResponse();
                if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
                    return Mono.just((Object)pollResponse);
                }
                KeyVaultBackupOperation keyVaultBackupOperation = (KeyVaultBackupOperation)pollResponse.getValue();
                if (keyVaultBackupOperation == null) {
                    LOGGER.warning("Backup operation does not exist. Activation operation failed.");
                    return Mono.just((Object)new PollResponse(LongRunningOperationStatus.fromString((String)"BACKUP_START_FAILED", (boolean)true), null));
                }
                String jobId = keyVaultBackupOperation.getOperationId();
                return FluxUtil.withContext(context -> this.clientImpl.fullBackupStatusWithResponseAsync(jobId, new RequestOptions().setContext(context))).map(response -> new SimpleResponse(response, (Object)((KeyVaultBackupOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((FullBackupOperation)((BinaryData)response.getValue()).toObject(FullBackupOperation.class))))).flatMap(KeyVaultBackupAsyncClient::processBackupOperationResponse);
            }
            catch (HttpResponseException e) {
                LOGGER.logExceptionAsError((RuntimeException)((Object)e));
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.FAILED, null));
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        };
    }

    private Function<PollingContext<KeyVaultBackupOperation>, Mono<String>> backupFetchOperation() {
        return pollingContext -> {
            try {
                String blobContainerUri = ((KeyVaultBackupOperation)pollingContext.getLatestResponse().getValue()).getAzureStorageBlobContainerUrl();
                if (blobContainerUri == null) {
                    return Mono.empty();
                }
                return Mono.just((Object)blobContainerUri);
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        };
    }

    private static Mono<PollResponse<KeyVaultBackupOperation>> processBackupOperationResponse(Response<KeyVaultBackupOperation> response) {
        String operationStatus = ((KeyVaultBackupOperation)response.getValue()).getStatus().toLowerCase(Locale.ROOT);
        return Mono.just((Object)new PollResponse(KeyVaultAdministrationUtil.toLongRunningOperationStatus(operationStatus.toLowerCase(Locale.ROOT)), (Object)((KeyVaultBackupOperation)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultRestoreOperation, Void> beginPreRestore(String folderUrl, String sasToken) {
        if (folderUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'folderUrl'")));
        }
        return new PollerFlux(this.getDefaultPollingInterval(), this.preRestoreActivationOperation(folderUrl, sasToken), this.restorePollOperation(), (pollingContext, firstResponse) -> Mono.error((Throwable)LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), pollingContext -> Mono.empty());
    }

    Mono<Response<KeyVaultRestoreOperation>> preRestoreWithResponse(String folderUrl, String sasToken, Context context) {
        String[] segments = folderUrl.split("/");
        String folderName = segments[segments.length - 1];
        String containerUrl = folderUrl.substring(0, folderUrl.length() - folderName.length());
        SASTokenParameter sasTokenParameter = new SASTokenParameter(containerUrl).setToken(sasToken).setUseManagedIdentity(sasToken == null);
        PreRestoreOperationParameters preRestoreOperationParameters = new PreRestoreOperationParameters().setFolderToRestore(folderName).setSasTokenParameters(sasTokenParameter);
        try {
            return this.clientImpl.preFullRestoreOperationWithResponseAsync(BinaryData.fromObject((Object)preRestoreOperationParameters), new RequestOptions().setContext(context)).map(restoreOperationResponse -> new SimpleResponse(restoreOperationResponse.getRequest(), restoreOperationResponse.getStatusCode(), restoreOperationResponse.getHeaders(), (Object)((KeyVaultRestoreOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((RestoreOperation)((BinaryData)restoreOperationResponse.getValue()).toObject(RestoreOperation.class)))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    private Function<PollingContext<KeyVaultRestoreOperation>, Mono<KeyVaultRestoreOperation>> preRestoreActivationOperation(String folderUrl, String sasToken) {
        return pollingContext -> {
            try {
                return FluxUtil.withContext(context -> this.preRestoreWithResponse(folderUrl, sasToken, (Context)context)).map(Response::getValue);
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        };
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultRestoreOperation, KeyVaultRestoreResult> beginRestore(String folderUrl, String sasToken) {
        if (folderUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'folderUrl'")));
        }
        return new PollerFlux(this.getDefaultPollingInterval(), this.restoreActivationOperation(folderUrl, sasToken), this.restorePollOperation(), (pollingContext, firstResponse) -> Mono.error((Throwable)LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), pollingContext -> Mono.just((Object)new KeyVaultRestoreResult()));
    }

    Mono<Response<KeyVaultRestoreOperation>> restoreWithResponse(String folderUrl, String sasToken, Context context) {
        String[] segments = folderUrl.split("/");
        String folderName = segments[segments.length - 1];
        String containerUrl = folderUrl.substring(0, folderUrl.length() - folderName.length());
        SASTokenParameter sasTokenParameter = new SASTokenParameter(containerUrl).setToken(sasToken).setUseManagedIdentity(sasToken == null);
        RestoreOperationParameters restoreOperationParameters = new RestoreOperationParameters(sasTokenParameter, folderName);
        try {
            return this.clientImpl.fullRestoreOperationWithResponseAsync(BinaryData.fromObject((Object)restoreOperationParameters), new RequestOptions().setContext(context)).map(restoreOperationResponse -> new SimpleResponse(restoreOperationResponse.getRequest(), restoreOperationResponse.getStatusCode(), restoreOperationResponse.getHeaders(), (Object)((KeyVaultRestoreOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((RestoreOperation)((BinaryData)restoreOperationResponse.getValue()).toObject(RestoreOperation.class)))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    private Function<PollingContext<KeyVaultRestoreOperation>, Mono<KeyVaultRestoreOperation>> restoreActivationOperation(String folderUrl, String sasToken) {
        return pollingContext -> {
            try {
                return FluxUtil.withContext(context -> this.restoreWithResponse(folderUrl, sasToken, (Context)context)).map(Response::getValue);
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        };
    }

    private Function<PollingContext<KeyVaultRestoreOperation>, Mono<PollResponse<KeyVaultRestoreOperation>>> restorePollOperation() {
        return pollingContext -> {
            try {
                PollResponse pollResponse = pollingContext.getLatestResponse();
                if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
                    return Mono.just((Object)pollResponse);
                }
                KeyVaultRestoreOperation keyVaultRestoreOperation = (KeyVaultRestoreOperation)pollResponse.getValue();
                if (keyVaultRestoreOperation == null) {
                    LOGGER.warning("Restore operation does not exist. Activation operation failed.");
                    return Mono.just((Object)new PollResponse(LongRunningOperationStatus.fromString((String)"RESTORE_START_FAILED", (boolean)true), null));
                }
                String jobId = keyVaultRestoreOperation.getOperationId();
                return FluxUtil.withContext(context -> this.clientImpl.restoreStatusWithResponseAsync(jobId, new RequestOptions().setContext(context)).map(response -> new SimpleResponse(response, (Object)((KeyVaultRestoreOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((RestoreOperation)((BinaryData)response.getValue()).toObject(RestoreOperation.class))))).flatMap(KeyVaultBackupAsyncClient::processRestoreOperationResponse));
            }
            catch (HttpResponseException e) {
                LOGGER.logExceptionAsError((RuntimeException)((Object)e));
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.FAILED, null));
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        };
    }

    static Mono<PollResponse<KeyVaultRestoreOperation>> processRestoreOperationResponse(Response<KeyVaultRestoreOperation> response) {
        String operationStatus = ((KeyVaultRestoreOperation)response.getValue()).getStatus().toLowerCase(Locale.ROOT);
        return Mono.just((Object)new PollResponse(KeyVaultAdministrationUtil.toLongRunningOperationStatus(operationStatus.toLowerCase(Locale.ROOT)), (Object)((KeyVaultRestoreOperation)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<KeyVaultSelectiveKeyRestoreOperation, KeyVaultSelectiveKeyRestoreResult> beginSelectiveKeyRestore(String keyName, String folderUrl, String sasToken) {
        if (keyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'keyName'")));
        }
        if (folderUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException(String.format("%s cannot be null.", "'folderUrl'")));
        }
        return new PollerFlux(this.getDefaultPollingInterval(), this.selectiveKeyRestoreActivationOperation(keyName, folderUrl, sasToken), this.selectiveKeyRestorePollOperation(), (pollingContext, firstResponse) -> Mono.error((Throwable)LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"))), pollingContext -> Mono.just((Object)new KeyVaultSelectiveKeyRestoreResult()));
    }

    Mono<Response<KeyVaultSelectiveKeyRestoreOperation>> selectiveKeyRestoreWithResponse(String keyName, String folderUrl, String sasToken, Context context) {
        String[] segments = folderUrl.split("/");
        String folderName = segments[segments.length - 1];
        String containerUrl = folderUrl.substring(0, folderUrl.length() - folderName.length());
        SASTokenParameter sasTokenParameter = new SASTokenParameter(containerUrl).setToken(sasToken).setUseManagedIdentity(sasToken == null);
        SelectiveKeyRestoreOperationParameters selectiveKeyRestoreOperationParameters = new SelectiveKeyRestoreOperationParameters(sasTokenParameter, folderName);
        try {
            return this.clientImpl.selectiveKeyRestoreOperationWithResponseAsync(keyName, BinaryData.fromObject((Object)selectiveKeyRestoreOperationParameters), new RequestOptions().setContext(context)).map(selectiveKeyRestoreOperationResponse -> new SimpleResponse(selectiveKeyRestoreOperationResponse.getRequest(), selectiveKeyRestoreOperationResponse.getStatusCode(), selectiveKeyRestoreOperationResponse.getHeaders(), (Object)((KeyVaultSelectiveKeyRestoreOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((SelectiveKeyRestoreOperation)((BinaryData)selectiveKeyRestoreOperationResponse.getValue()).toObject(SelectiveKeyRestoreOperation.class)))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    private Function<PollingContext<KeyVaultSelectiveKeyRestoreOperation>, Mono<KeyVaultSelectiveKeyRestoreOperation>> selectiveKeyRestoreActivationOperation(String keyName, String folderUrl, String sasToken) {
        return pollingContext -> {
            try {
                return FluxUtil.withContext(context -> this.selectiveKeyRestoreWithResponse(keyName, folderUrl, sasToken, (Context)context)).map(Response::getValue);
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        };
    }

    private Function<PollingContext<KeyVaultSelectiveKeyRestoreOperation>, Mono<PollResponse<KeyVaultSelectiveKeyRestoreOperation>>> selectiveKeyRestorePollOperation() {
        return pollingContext -> {
            try {
                PollResponse pollResponse = pollingContext.getLatestResponse();
                if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
                    return Mono.just((Object)pollResponse);
                }
                KeyVaultSelectiveKeyRestoreOperation keyVaultSelectiveKeyRestoreOperation = (KeyVaultSelectiveKeyRestoreOperation)pollResponse.getValue();
                if (keyVaultSelectiveKeyRestoreOperation == null) {
                    LOGGER.warning("Restore operation does not exist. Activation operation failed.");
                    return Mono.just((Object)new PollResponse(LongRunningOperationStatus.fromString((String)"SELECTIVE_RESTORE_START_FAILED", (boolean)true), null));
                }
                String jobId = keyVaultSelectiveKeyRestoreOperation.getOperationId();
                return FluxUtil.withContext(context -> this.clientImpl.selectiveKeyRestoreStatusWithResponseAsync(jobId, new RequestOptions().setContext(context)).map(response -> new SimpleResponse(response, (Object)((KeyVaultSelectiveKeyRestoreOperation)KeyVaultAdministrationUtil.transformToLongRunningOperation((SelectiveKeyRestoreOperation)((BinaryData)response.getValue()).toObject(SelectiveKeyRestoreOperation.class))))).flatMap(KeyVaultBackupAsyncClient::processSelectiveKeyRestoreOperationResponse));
            }
            catch (HttpResponseException e) {
                LOGGER.logExceptionAsError((RuntimeException)((Object)e));
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.FAILED, null));
            }
            catch (RuntimeException e) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
            }
        };
    }

    private static Mono<PollResponse<KeyVaultSelectiveKeyRestoreOperation>> processSelectiveKeyRestoreOperationResponse(Response<KeyVaultSelectiveKeyRestoreOperation> response) {
        String operationStatus = ((KeyVaultSelectiveKeyRestoreOperation)response.getValue()).getStatus().toLowerCase(Locale.ROOT);
        return Mono.just((Object)new PollResponse(KeyVaultAdministrationUtil.toLongRunningOperationStatus(operationStatus.toLowerCase(Locale.ROOT)), (Object)((KeyVaultSelectiveKeyRestoreOperation)response.getValue())));
    }
}

