/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.administration.KeyVaultAccessControlClientBuilder;
import com.azure.security.keyvault.administration.KeyVaultAdministrationServiceVersion;
import com.azure.security.keyvault.administration.KeyVaultAdministrationUtil;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationClientImpl;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationUtils;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignment;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentCreateParameters;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinition;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinitionCreateParameters;
import com.azure.security.keyvault.administration.models.KeyVaultAdministrationException;
import com.azure.security.keyvault.administration.models.KeyVaultRoleAssignment;
import com.azure.security.keyvault.administration.models.KeyVaultRoleDefinition;
import com.azure.security.keyvault.administration.models.KeyVaultRoleScope;
import com.azure.security.keyvault.administration.models.SetRoleDefinitionOptions;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;

@ServiceClient(builder=KeyVaultAccessControlClientBuilder.class)
public final class KeyVaultAccessControlClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultAccessControlClient.class);
    private final KeyVaultAdministrationClientImpl implClient;
    private final String vaultUrl;

    KeyVaultAccessControlClient(URL vaultUrl, HttpPipeline httpPipeline, KeyVaultAdministrationServiceVersion serviceVersion) {
        Objects.requireNonNull(vaultUrl, "Azure Key Vault endpoint url is required.");
        this.vaultUrl = vaultUrl.toString();
        this.implClient = new KeyVaultAdministrationClientImpl(httpPipeline, this.vaultUrl, serviceVersion);
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleDefinition> listRoleDefinitions(KeyVaultRoleScope roleScope) {
        return this.listRoleDefinitions(roleScope, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleDefinition> listRoleDefinitions(KeyVaultRoleScope roleScope, Context context) {
        Objects.requireNonNull(roleScope, String.format("%s cannot be null.", "'roleScope'"));
        try {
            return this.implClient.getRoleDefinitions().list(roleScope.toString(), new RequestOptions().setContext(context)).mapPage(binaryData -> KeyVaultAdministrationUtil.roleDefinitionToKeyVaultRoleDefinition((RoleDefinition)binaryData.toObject(RoleDefinition.class)));
        }
        catch (HttpResponseException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleDefinition setRoleDefinition(KeyVaultRoleScope roleScope) {
        return this.setRoleDefinition(roleScope, UUID.randomUUID().toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleDefinition setRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return (KeyVaultRoleDefinition)this.setRoleDefinitionWithResponse(new SetRoleDefinitionOptions(roleScope, roleDefinitionName), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleDefinition> setRoleDefinitionWithResponse(SetRoleDefinitionOptions options, Context context) {
        RoleDefinitionCreateParameters parameters = KeyVaultAdministrationUtil.validateAndGetRoleDefinitionCreateParameters(options);
        try {
            Response<BinaryData> roleDefinitionResponse = this.implClient.getRoleDefinitions().createOrUpdateWithResponse(options.getRoleScope().toString(), options.getRoleDefinitionName(), BinaryData.fromObject((Object)parameters), new RequestOptions().setContext(context));
            return KeyVaultAdministrationUtil.transformBinaryDataResponse(roleDefinitionResponse, binaryData -> KeyVaultAdministrationUtil.roleDefinitionToKeyVaultRoleDefinition((RoleDefinition)binaryData.toObject(RoleDefinition.class)));
        }
        catch (HttpResponseException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleDefinition getRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return (KeyVaultRoleDefinition)this.getRoleDefinitionWithResponse(roleScope, roleDefinitionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleDefinition> getRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        KeyVaultAdministrationUtil.validateRoleDefinitionParameters(roleScope, roleDefinitionName);
        try {
            Response<BinaryData> roleDefinitionResponse = this.implClient.getRoleDefinitions().getWithResponse(roleScope.toString(), roleDefinitionName, new RequestOptions().setContext(context));
            return KeyVaultAdministrationUtil.transformBinaryDataResponse(roleDefinitionResponse, binaryData -> KeyVaultAdministrationUtil.roleDefinitionToKeyVaultRoleDefinition((RoleDefinition)binaryData.toObject(RoleDefinition.class)));
        }
        catch (HttpResponseException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        this.deleteRoleDefinitionWithResponse(roleScope, roleDefinitionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        KeyVaultAdministrationUtil.validateRoleDefinitionParameters(roleScope, roleDefinitionName);
        try {
            Response<BinaryData> roleDefinitionResponse = this.implClient.getRoleDefinitions().deleteWithResponse(roleScope.toString(), roleDefinitionName, new RequestOptions().setContext(context));
            return new SimpleResponse(roleDefinitionResponse, null);
        }
        catch (HttpResponseException e) {
            KeyVaultAdministrationException mappedException = KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e);
            return KeyVaultAdministrationUtil.swallowExceptionForStatusCodeSync(404, mappedException, LOGGER);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleAssignment> listRoleAssignments(KeyVaultRoleScope roleScope) {
        return this.listRoleAssignments(roleScope, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleAssignment> listRoleAssignments(KeyVaultRoleScope roleScope, Context context) {
        Objects.requireNonNull(roleScope, String.format("%s cannot be null.", "'roleScope'"));
        try {
            return this.implClient.getRoleAssignments().listForScope(roleScope.toString(), new RequestOptions().setContext(context)).mapPage(binaryData -> KeyVaultAdministrationUtil.roleAssignmentToKeyVaultRoleAssignment((RoleAssignment)binaryData.toObject(RoleAssignment.class)));
        }
        catch (HttpResponseException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleAssignment createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId) {
        return (KeyVaultRoleAssignment)this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, UUID.randomUUID().toString(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleAssignment createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName) {
        return (KeyVaultRoleAssignment)this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, roleAssignmentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleAssignment> createRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName, Context context) {
        RoleAssignmentCreateParameters parameters = KeyVaultAdministrationUtil.validateAndGetRoleAssignmentCreateParameters(roleScope, roleDefinitionId, principalId, roleAssignmentName);
        try {
            Response<BinaryData> roleAssignmentResponse = this.implClient.getRoleAssignments().createWithResponse(roleScope.toString(), roleAssignmentName, BinaryData.fromObject((Object)parameters), new RequestOptions().setContext(context));
            return KeyVaultAdministrationUtil.transformBinaryDataResponse(roleAssignmentResponse, binaryData -> KeyVaultAdministrationUtil.roleAssignmentToKeyVaultRoleAssignment((RoleAssignment)binaryData.toObject(RoleAssignment.class)));
        }
        catch (HttpResponseException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleAssignment getRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return (KeyVaultRoleAssignment)this.getRoleAssignmentWithResponse(roleScope, roleAssignmentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleAssignment> getRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        KeyVaultAdministrationUtil.validateRoleAssignmentParameters(roleScope, roleAssignmentName);
        try {
            Response<BinaryData> roleAssignmentResponse = this.implClient.getRoleAssignments().getWithResponse(roleScope.toString(), roleAssignmentName, new RequestOptions().setContext(context));
            return KeyVaultAdministrationUtil.transformBinaryDataResponse(roleAssignmentResponse, binaryData -> KeyVaultAdministrationUtil.roleAssignmentToKeyVaultRoleAssignment((RoleAssignment)binaryData.toObject(RoleAssignment.class)));
        }
        catch (HttpResponseException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        this.deleteRoleAssignmentWithResponse(roleScope, roleAssignmentName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        KeyVaultAdministrationUtil.validateRoleAssignmentParameters(roleScope, roleAssignmentName);
        try {
            Response<BinaryData> roleAssignmentResponse = this.implClient.getRoleAssignments().deleteWithResponse(roleScope.toString(), roleAssignmentName, new RequestOptions().setContext(context));
            return new SimpleResponse(roleAssignmentResponse, null);
        }
        catch (HttpResponseException e) {
            KeyVaultAdministrationException mappedException = KeyVaultAdministrationUtils.toKeyVaultAdministrationException(e);
            return KeyVaultAdministrationUtil.swallowExceptionForStatusCodeSync(404, mappedException, LOGGER);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }
}

