/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.administration.KeyVaultAccessControlClientBuilder;
import com.azure.security.keyvault.administration.KeyVaultAdministrationServiceVersion;
import com.azure.security.keyvault.administration.KeyVaultAdministrationUtil;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationClientImpl;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationUtils;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignment;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentCreateParameters;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinition;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinitionCreateParameters;
import com.azure.security.keyvault.administration.models.KeyVaultAdministrationException;
import com.azure.security.keyvault.administration.models.KeyVaultRoleAssignment;
import com.azure.security.keyvault.administration.models.KeyVaultRoleDefinition;
import com.azure.security.keyvault.administration.models.KeyVaultRoleScope;
import com.azure.security.keyvault.administration.models.SetRoleDefinitionOptions;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;
import reactor.core.publisher.Mono;

@ServiceClient(builder=KeyVaultAccessControlClientBuilder.class, isAsync=true)
public final class KeyVaultAccessControlAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultAccessControlAsyncClient.class);
    private final KeyVaultAdministrationClientImpl clientImpl;
    private final String vaultUrl;
    private final HttpPipeline pipeline;

    KeyVaultAccessControlAsyncClient(URL vaultUrl, HttpPipeline httpPipeline, KeyVaultAdministrationServiceVersion serviceVersion) {
        Objects.requireNonNull(vaultUrl, "Azure Key Vault endpoint url is required.");
        this.vaultUrl = vaultUrl.toString();
        this.pipeline = httpPipeline;
        this.clientImpl = new KeyVaultAdministrationClientImpl(httpPipeline, this.vaultUrl, serviceVersion);
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyVaultRoleDefinition> listRoleDefinitions(KeyVaultRoleScope roleScope) {
        try {
            Objects.requireNonNull(roleScope, String.format("%s cannot be null.", "'roleScope'"));
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.clientImpl.getRoleDefinitions().listSinglePageAsync(roleScope.toString(), new RequestOptions().setContext(context)).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(pagedResponse -> KeyVaultAdministrationUtil.mapPagedResponse(pagedResponse, binaryData -> KeyVaultAdministrationUtil.roleDefinitionToKeyVaultRoleDefinition((RoleDefinition)binaryData.toObject(RoleDefinition.class))))), nextLink -> FluxUtil.withContext(context -> this.clientImpl.getRoleDefinitions().listNextSinglePageAsync((String)nextLink, new RequestOptions().setContext(context)).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(pagedResponse -> KeyVaultAdministrationUtil.mapPagedResponse(pagedResponse, binaryData -> KeyVaultAdministrationUtil.roleDefinitionToKeyVaultRoleDefinition((RoleDefinition)binaryData.toObject(RoleDefinition.class))))));
        }
        catch (RuntimeException e) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleDefinition> setRoleDefinition(KeyVaultRoleScope roleScope) {
        return this.setRoleDefinition(roleScope, UUID.randomUUID().toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleDefinition> setRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return this.setRoleDefinitionWithResponse(new SetRoleDefinitionOptions(roleScope, roleDefinitionName)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleDefinition>> setRoleDefinitionWithResponse(SetRoleDefinitionOptions options) {
        return FluxUtil.withContext(context -> this.setRoleDefinitionWithResponse(options, (Context)context));
    }

    Mono<Response<KeyVaultRoleDefinition>> setRoleDefinitionWithResponse(SetRoleDefinitionOptions options, Context context) {
        try {
            RoleDefinitionCreateParameters parameters = KeyVaultAdministrationUtil.validateAndGetRoleDefinitionCreateParameters(options);
            return this.clientImpl.getRoleDefinitions().createOrUpdateWithResponseAsync(options.getRoleScope().toString(), options.getRoleDefinitionName(), BinaryData.fromObject((Object)parameters), new RequestOptions().setContext(context)).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> KeyVaultAdministrationUtil.transformBinaryDataResponse((Response<BinaryData>)response, binaryData -> KeyVaultAdministrationUtil.roleDefinitionToKeyVaultRoleDefinition((RoleDefinition)binaryData.toObject(RoleDefinition.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleDefinition> getRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return this.getRoleDefinitionWithResponse(roleScope, roleDefinitionName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleDefinition>> getRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return FluxUtil.withContext(context -> this.getRoleDefinitionWithResponse(roleScope, roleDefinitionName, (Context)context));
    }

    Mono<Response<KeyVaultRoleDefinition>> getRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        try {
            KeyVaultAdministrationUtil.validateRoleDefinitionParameters(roleScope, roleDefinitionName);
            return this.clientImpl.getRoleDefinitions().getWithResponseAsync(roleScope.toString(), roleDefinitionName, new RequestOptions().setContext(context)).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> KeyVaultAdministrationUtil.transformBinaryDataResponse((Response<BinaryData>)response, binaryData -> KeyVaultAdministrationUtil.roleDefinitionToKeyVaultRoleDefinition((RoleDefinition)binaryData.toObject(RoleDefinition.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return this.deleteRoleDefinitionWithResponse(roleScope, roleDefinitionName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return FluxUtil.withContext(context -> this.deleteRoleDefinitionWithResponse(roleScope, roleDefinitionName, (Context)context));
    }

    Mono<Response<Void>> deleteRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        try {
            KeyVaultAdministrationUtil.validateRoleDefinitionParameters(roleScope, roleDefinitionName);
            return this.clientImpl.getRoleDefinitions().deleteWithResponseAsync(roleScope.toString(), roleDefinitionName, new RequestOptions().setContext(context)).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> new SimpleResponse(response, null)).onErrorResume(KeyVaultAdministrationException.class, e -> KeyVaultAdministrationUtil.swallowExceptionForStatusCodeAsync(404, e, LOGGER));
        }
        catch (RuntimeException e2) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e2);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyVaultRoleAssignment> listRoleAssignments(KeyVaultRoleScope roleScope) {
        try {
            Objects.requireNonNull(roleScope, String.format("%s cannot be null.", "'roleScope'"));
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.clientImpl.getRoleAssignments().listForScopeSinglePageAsync(roleScope.toString(), new RequestOptions().setContext(context)).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(pagedResponse -> KeyVaultAdministrationUtil.mapPagedResponse(pagedResponse, binaryData -> KeyVaultAdministrationUtil.roleAssignmentToKeyVaultRoleAssignment((RoleAssignment)binaryData.toObject(RoleAssignment.class))))), nextLink -> FluxUtil.withContext(context -> this.clientImpl.getRoleAssignments().listForScopeNextSinglePageAsync((String)nextLink, new RequestOptions().setContext(context)).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(pagedResponse -> KeyVaultAdministrationUtil.mapPagedResponse(pagedResponse, binaryData -> KeyVaultAdministrationUtil.roleAssignmentToKeyVaultRoleAssignment((RoleAssignment)binaryData.toObject(RoleAssignment.class))))));
        }
        catch (RuntimeException e) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleAssignment> createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId) {
        return this.createRoleAssignment(roleScope, roleDefinitionId, principalId, UUID.randomUUID().toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleAssignment> createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName) {
        return this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, roleAssignmentName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleAssignment>> createRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName) {
        return FluxUtil.withContext(context -> this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, roleAssignmentName, (Context)context));
    }

    Mono<Response<KeyVaultRoleAssignment>> createRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName, Context context) {
        try {
            RoleAssignmentCreateParameters parameters = KeyVaultAdministrationUtil.validateAndGetRoleAssignmentCreateParameters(roleScope, roleDefinitionId, principalId, roleAssignmentName);
            return this.clientImpl.getRoleAssignments().createWithResponseAsync(roleScope.toString(), roleAssignmentName, BinaryData.fromObject((Object)parameters), new RequestOptions().setContext(context)).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> KeyVaultAdministrationUtil.transformBinaryDataResponse((Response<BinaryData>)response, binaryData -> KeyVaultAdministrationUtil.roleAssignmentToKeyVaultRoleAssignment((RoleAssignment)binaryData.toObject(RoleAssignment.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleAssignment> getRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return this.getRoleAssignmentWithResponse(roleScope, roleAssignmentName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleAssignment>> getRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return FluxUtil.withContext(context -> this.getRoleAssignmentWithResponse(roleScope, roleAssignmentName, (Context)context));
    }

    Mono<Response<KeyVaultRoleAssignment>> getRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        try {
            KeyVaultAdministrationUtil.validateRoleAssignmentParameters(roleScope, roleAssignmentName);
            return this.clientImpl.getRoleAssignments().getWithResponseAsync(roleScope.toString(), roleAssignmentName, new RequestOptions().setContext(context)).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> KeyVaultAdministrationUtil.transformBinaryDataResponse((Response<BinaryData>)response, binaryData -> KeyVaultAdministrationUtil.roleAssignmentToKeyVaultRoleAssignment((RoleAssignment)binaryData.toObject(RoleAssignment.class))));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return this.deleteRoleAssignmentWithResponse(roleScope, roleAssignmentName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return FluxUtil.withContext(context -> this.deleteRoleAssignmentWithResponse(roleScope, roleAssignmentName, (Context)context));
    }

    Mono<Response<Void>> deleteRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        try {
            KeyVaultAdministrationUtil.validateRoleAssignmentParameters(roleScope, roleAssignmentName);
            return this.clientImpl.getRoleAssignments().deleteWithResponseAsync(roleScope.toString(), roleAssignmentName, new RequestOptions().setContext(context)).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> new SimpleResponse(response, null)).onErrorResume(KeyVaultAdministrationException.class, e -> KeyVaultAdministrationUtil.swallowExceptionForStatusCodeAsync(404, e, LOGGER));
        }
        catch (RuntimeException e2) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e2);
        }
    }
}

