/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinitionProperties;
import com.azure.security.keyvault.administration.models.KeyVaultRoleDefinitionType;
import java.io.IOException;

public final class RoleDefinition
implements JsonSerializable<RoleDefinition> {
    private String id;
    private String name;
    private KeyVaultRoleDefinitionType type;
    private RoleDefinitionProperties properties;

    private RoleDefinition() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public KeyVaultRoleDefinitionType getType() {
        return this.type;
    }

    public RoleDefinitionProperties getProperties() {
        return this.properties;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static RoleDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (RoleDefinition)jsonReader.readObject(reader -> {
            RoleDefinition deserializedRoleDefinition = new RoleDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRoleDefinition.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRoleDefinition.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRoleDefinition.type = KeyVaultRoleDefinitionType.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRoleDefinition.properties = RoleDefinitionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleDefinition;
        });
    }
}

