/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentPropertiesWithScope;
import java.io.IOException;

public final class RoleAssignment
implements JsonSerializable<RoleAssignment> {
    private String id;
    private String name;
    private String type;
    private RoleAssignmentPropertiesWithScope properties;

    private RoleAssignment() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public RoleAssignmentPropertiesWithScope getProperties() {
        return this.properties;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static RoleAssignment fromJson(JsonReader jsonReader) throws IOException {
        return (RoleAssignment)jsonReader.readObject(reader -> {
            RoleAssignment deserializedRoleAssignment = new RoleAssignment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRoleAssignment.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRoleAssignment.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRoleAssignment.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRoleAssignment.properties = RoleAssignmentPropertiesWithScope.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleAssignment;
        });
    }
}

