/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.implementation.models.SASTokenParameter;
import java.io.IOException;
import java.util.ArrayList;

public final class RestoreOperationParameters
implements JsonSerializable<RestoreOperationParameters> {
    private final SASTokenParameter sasTokenParameters;
    private final String folderToRestore;

    public RestoreOperationParameters(SASTokenParameter sasTokenParameters, String folderToRestore) {
        this.sasTokenParameters = sasTokenParameters;
        this.folderToRestore = folderToRestore;
    }

    public SASTokenParameter getSasTokenParameters() {
        return this.sasTokenParameters;
    }

    public String getFolderToRestore() {
        return this.folderToRestore;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sasTokenParameters", (JsonSerializable)this.sasTokenParameters);
        jsonWriter.writeStringField("folderToRestore", this.folderToRestore);
        return jsonWriter.writeEndObject();
    }

    public static RestoreOperationParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RestoreOperationParameters)jsonReader.readObject(reader -> {
            boolean sasTokenParametersFound = false;
            SASTokenParameter sasTokenParameters = null;
            boolean folderToRestoreFound = false;
            String folderToRestore = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sasTokenParameters".equals(fieldName)) {
                    sasTokenParameters = SASTokenParameter.fromJson(reader);
                    sasTokenParametersFound = true;
                    continue;
                }
                if ("folderToRestore".equals(fieldName)) {
                    folderToRestore = reader.getString();
                    folderToRestoreFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (sasTokenParametersFound && folderToRestoreFound) {
                return new RestoreOperationParameters(sasTokenParameters, folderToRestore);
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!sasTokenParametersFound) {
                missingProperties.add("sasTokenParameters");
            }
            if (!folderToRestoreFound) {
                missingProperties.add("folderToRestore");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

