/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.administration.KeyVaultSettingsAsyncClient;
import com.azure.security.keyvault.administration.KeyVaultSettingsClientBuilder;
import com.azure.security.keyvault.administration.implementation.KeyVaultSettingsClientImpl;
import com.azure.security.keyvault.administration.implementation.models.Setting;
import com.azure.security.keyvault.administration.implementation.models.SettingsListResult;
import com.azure.security.keyvault.administration.models.KeyVaultGetSettingsResult;
import com.azure.security.keyvault.administration.models.KeyVaultSetting;
import com.azure.security.keyvault.administration.models.KeyVaultSettingType;
import java.util.ArrayList;
import java.util.Objects;

@ServiceClient(builder=KeyVaultSettingsClientBuilder.class)
public final class KeyVaultSettingsClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultSettingsClient.class);
    private final String vaultUrl;
    private final KeyVaultSettingsClientImpl implClient;

    KeyVaultSettingsClient(String vaultUrl, KeyVaultSettingsClientImpl implClient) {
        this.vaultUrl = vaultUrl;
        this.implClient = implClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSetting updateSetting(KeyVaultSetting setting) {
        Objects.requireNonNull(setting, String.format("%s cannot be null.", "'setting'"));
        try {
            String settingValue = null;
            if (setting.getType() == KeyVaultSettingType.BOOLEAN) {
                settingValue = Boolean.toString(setting.asBoolean());
            }
            return KeyVaultSettingsAsyncClient.transformToKeyVaultSetting(this.implClient.updateSetting(this.vaultUrl, setting.getName(), settingValue));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSetting> updateSettingWithResponse(KeyVaultSetting setting, Context context) {
        Objects.requireNonNull(setting, String.format("%s cannot be null.", "'setting'"));
        try {
            String settingValue = null;
            if (setting.getType() == KeyVaultSettingType.BOOLEAN) {
                settingValue = Boolean.toString(setting.asBoolean());
            }
            Response<Setting> response = this.implClient.updateSettingWithResponse(this.vaultUrl, setting.getName(), settingValue, context);
            return new SimpleResponse(response, (Object)KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)response.getValue()));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSetting getSetting(String name) {
        try {
            return KeyVaultSettingsAsyncClient.transformToKeyVaultSetting(this.implClient.getSetting(this.vaultUrl, name));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSetting> getSettingWithResponse(String name, Context context) {
        try {
            Response<Setting> response = this.implClient.getSettingWithResponse(this.vaultUrl, name, context);
            return new SimpleResponse(response, (Object)KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)response.getValue()));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultGetSettingsResult getSettings() {
        ArrayList<KeyVaultSetting> keyVaultSettings = new ArrayList<KeyVaultSetting>();
        try {
            this.implClient.getSettings(this.vaultUrl).getSettings().forEach(setting -> keyVaultSettings.add(KeyVaultSettingsAsyncClient.transformToKeyVaultSetting(setting)));
            return new KeyVaultGetSettingsResult(keyVaultSettings);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultGetSettingsResult> getSettingsWithResponse(Context context) {
        try {
            Response<SettingsListResult> response = this.implClient.getSettingsWithResponse(this.vaultUrl, context);
            ArrayList<KeyVaultSetting> keyVaultSettings = new ArrayList<KeyVaultSetting>();
            ((SettingsListResult)response.getValue()).getSettings().forEach(setting -> keyVaultSettings.add(KeyVaultSettingsAsyncClient.transformToKeyVaultSetting(setting)));
            return new SimpleResponse(response, (Object)new KeyVaultGetSettingsResult(keyVaultSettings));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }
}

