/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.administration.KeyVaultAccessControlClientBuilder;
import com.azure.security.keyvault.administration.KeyVaultAdministrationServiceVersion;
import com.azure.security.keyvault.administration.KeyVaultAdministrationUtil;
import com.azure.security.keyvault.administration.implementation.KeyVaultAccessControlClientImpl;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationUtils;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignment;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentCreateParameters;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinition;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinitionCreateParameters;
import com.azure.security.keyvault.administration.models.KeyVaultAdministrationException;
import com.azure.security.keyvault.administration.models.KeyVaultRoleAssignment;
import com.azure.security.keyvault.administration.models.KeyVaultRoleDefinition;
import com.azure.security.keyvault.administration.models.KeyVaultRoleScope;
import com.azure.security.keyvault.administration.models.SetRoleDefinitionOptions;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;
import reactor.core.publisher.Mono;

@ServiceClient(builder=KeyVaultAccessControlClientBuilder.class, isAsync=true)
public final class KeyVaultAccessControlAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultAccessControlAsyncClient.class);
    private final KeyVaultAccessControlClientImpl clientImpl;
    private final String vaultUrl;
    private final String serviceVersion;
    private final HttpPipeline pipeline;

    KeyVaultAccessControlAsyncClient(URL vaultUrl, HttpPipeline httpPipeline, KeyVaultAdministrationServiceVersion serviceVersion) {
        Objects.requireNonNull(vaultUrl, "Azure Key Vault endpoint url is required.");
        this.vaultUrl = vaultUrl.toString();
        this.serviceVersion = serviceVersion.getVersion();
        this.pipeline = httpPipeline;
        this.clientImpl = new KeyVaultAccessControlClientImpl(httpPipeline, this.serviceVersion);
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyVaultRoleDefinition> listRoleDefinitions(KeyVaultRoleScope roleScope) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listRoleDefinitionsFirstPage(this.vaultUrl, roleScope, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listRoleDefinitionsNextPage((String)continuationToken, (Context)context)));
    }

    PagedFlux<KeyVaultRoleDefinition> listRoleDefinitions(KeyVaultRoleScope roleScope, Context context) {
        return new PagedFlux(() -> this.listRoleDefinitionsFirstPage(this.vaultUrl, roleScope, context), continuationToken -> this.listRoleDefinitionsNextPage((String)continuationToken, context));
    }

    Mono<PagedResponse<KeyVaultRoleDefinition>> listRoleDefinitionsFirstPage(String vaultUrl, KeyVaultRoleScope roleScope, Context context) {
        try {
            Objects.requireNonNull(roleScope, String.format("%s cannot be null.", "'roleScope'"));
            return this.clientImpl.getRoleDefinitions().listSinglePageAsync(vaultUrl, roleScope.toString(), null, context).doOnRequest(ignored -> LOGGER.verbose("Listing role definitions for roleScope - {}", new Object[]{roleScope})).doOnSuccess(response -> LOGGER.verbose("Listed role definitions for roleScope - {}", new Object[]{roleScope})).doOnError(error -> LOGGER.warning("Failed to list role definitions for roleScope - {}", new Object[]{roleScope, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAdministrationUtil::transformRoleDefinitionsPagedResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<KeyVaultRoleDefinition>> listRoleDefinitionsNextPage(String continuationToken, Context context) {
        try {
            return this.clientImpl.getRoleDefinitions().listNextSinglePageAsync(continuationToken, this.vaultUrl, context).doOnRequest(ignored -> LOGGER.verbose("Listing next role definitions page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> LOGGER.verbose("Listed next role definitions page - Page {}", new Object[]{continuationToken})).doOnError(error -> LOGGER.warning("Failed to list next role definitions page - Page {}", new Object[]{continuationToken, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAdministrationUtil::transformRoleDefinitionsPagedResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleDefinition> setRoleDefinition(KeyVaultRoleScope roleScope) {
        return this.setRoleDefinition(roleScope, UUID.randomUUID().toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleDefinition> setRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return this.setRoleDefinitionWithResponse(new SetRoleDefinitionOptions(roleScope, roleDefinitionName)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleDefinition>> setRoleDefinitionWithResponse(SetRoleDefinitionOptions options) {
        return FluxUtil.withContext(context -> this.setRoleDefinitionWithResponse(options, (Context)context));
    }

    Mono<Response<KeyVaultRoleDefinition>> setRoleDefinitionWithResponse(SetRoleDefinitionOptions options, Context context) {
        try {
            RoleDefinitionCreateParameters parameters = KeyVaultAdministrationUtil.validateAndGetRoleDefinitionCreateParameters(options);
            return this.clientImpl.getRoleDefinitions().createOrUpdateWithResponseAsync(this.vaultUrl, options.getRoleScope().toString(), options.getRoleDefinitionName(), parameters, context).doOnRequest(ignored -> LOGGER.verbose("Creating role definition - {}", new Object[]{options.getRoleDefinitionName()})).doOnSuccess(response -> LOGGER.verbose("Created role definition - {}", new Object[]{((RoleDefinition)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to create role definition - {}", new Object[]{options.getRoleDefinitionName(), error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAdministrationUtil::transformRoleDefinitionResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleDefinition> getRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return this.getRoleDefinitionWithResponse(roleScope, roleDefinitionName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleDefinition>> getRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return FluxUtil.withContext(context -> this.getRoleDefinitionWithResponse(roleScope, roleDefinitionName, (Context)context));
    }

    Mono<Response<KeyVaultRoleDefinition>> getRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        try {
            KeyVaultAdministrationUtil.validateRoleDefinitionParameters(roleScope, roleDefinitionName);
            return this.clientImpl.getRoleDefinitions().getWithResponseAsync(this.vaultUrl, roleScope.toString(), roleDefinitionName, context).doOnRequest(ignored -> LOGGER.verbose("Retrieving role definition - {}", new Object[]{roleDefinitionName})).doOnSuccess(response -> LOGGER.verbose("Retrieved role definition - {}", new Object[]{((RoleDefinition)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to retrieved role definition - {}", new Object[]{roleDefinitionName, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAdministrationUtil::transformRoleDefinitionResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return this.deleteRoleDefinitionWithResponse(roleScope, roleDefinitionName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return FluxUtil.withContext(context -> this.deleteRoleDefinitionWithResponse(roleScope, roleDefinitionName, (Context)context));
    }

    Mono<Response<Void>> deleteRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        try {
            KeyVaultAdministrationUtil.validateRoleDefinitionParameters(roleScope, roleDefinitionName);
            return this.clientImpl.getRoleDefinitions().deleteWithResponseAsync(this.vaultUrl, roleScope.toString(), roleDefinitionName, context).doOnRequest(ignored -> LOGGER.verbose("Deleting role definition - {}", new Object[]{roleDefinitionName})).doOnSuccess(response -> LOGGER.verbose("Deleted role definition - {}", new Object[]{((RoleDefinition)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to delete role definition - {}", new Object[]{roleDefinitionName, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> new SimpleResponse(response, null)).onErrorResume(KeyVaultAdministrationException.class, e -> KeyVaultAdministrationUtil.swallowExceptionForStatusCodeAsync(404, e, LOGGER));
        }
        catch (RuntimeException e2) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e2);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyVaultRoleAssignment> listRoleAssignments(KeyVaultRoleScope roleScope) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listRoleAssignmentsFirstPage(this.vaultUrl, roleScope, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listRoleAssignmentsNextPage((String)continuationToken, (Context)context)));
    }

    PagedFlux<KeyVaultRoleAssignment> listRoleAssignments(KeyVaultRoleScope roleScope, Context context) {
        return new PagedFlux(() -> this.listRoleAssignmentsFirstPage(this.vaultUrl, roleScope, context), continuationToken -> this.listRoleAssignmentsNextPage((String)continuationToken, context));
    }

    Mono<PagedResponse<KeyVaultRoleAssignment>> listRoleAssignmentsFirstPage(String vaultUrl, KeyVaultRoleScope roleScope, Context context) {
        try {
            Objects.requireNonNull(roleScope, String.format("%s cannot be null.", "'roleScope'"));
            return this.clientImpl.getRoleAssignments().listForScopeSinglePageAsync(vaultUrl, roleScope.toString(), null, context).doOnRequest(ignored -> LOGGER.verbose("Listing role assignments for roleScope - {}", new Object[]{roleScope})).doOnSuccess(response -> LOGGER.verbose("Listed role assignments for roleScope - {}", new Object[]{roleScope})).doOnError(error -> LOGGER.warning("Failed to list role assignments for roleScope - {}", new Object[]{roleScope, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAdministrationUtil::transformRoleAssignmentsPagedResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<KeyVaultRoleAssignment>> listRoleAssignmentsNextPage(String continuationToken, Context context) {
        try {
            return this.clientImpl.getRoleAssignments().listForScopeNextSinglePageAsync(continuationToken, this.vaultUrl, context).doOnRequest(ignored -> LOGGER.verbose("Listing next role assignments page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> LOGGER.verbose("Listed next role assignments page - Page {}", new Object[]{continuationToken})).doOnError(error -> LOGGER.warning("Failed to list next role assignments page - Page {}", new Object[]{continuationToken, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAdministrationUtil::transformRoleAssignmentsPagedResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleAssignment> createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId) {
        return this.createRoleAssignment(roleScope, roleDefinitionId, principalId, UUID.randomUUID().toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleAssignment> createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName) {
        return this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, roleAssignmentName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleAssignment>> createRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName) {
        return FluxUtil.withContext(context -> this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, roleAssignmentName, (Context)context));
    }

    Mono<Response<KeyVaultRoleAssignment>> createRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName, Context context) {
        try {
            RoleAssignmentCreateParameters parameters = KeyVaultAdministrationUtil.validateAndGetRoleAssignmentCreateParameters(roleScope, roleDefinitionId, principalId, roleAssignmentName);
            return this.clientImpl.getRoleAssignments().createWithResponseAsync(this.vaultUrl, roleScope.toString(), roleAssignmentName, parameters, context).doOnRequest(ignored -> LOGGER.verbose("Creating role assignment - {}", new Object[]{roleAssignmentName})).doOnSuccess(response -> LOGGER.verbose("Created role assignment - {}", new Object[]{((RoleAssignment)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to create role assignment - {}", new Object[]{roleAssignmentName, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAdministrationUtil::transformRoleAssignmentResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleAssignment> getRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return this.getRoleAssignmentWithResponse(roleScope, roleAssignmentName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleAssignment>> getRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return FluxUtil.withContext(context -> this.getRoleAssignmentWithResponse(roleScope, roleAssignmentName, (Context)context));
    }

    Mono<Response<KeyVaultRoleAssignment>> getRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        try {
            KeyVaultAdministrationUtil.validateRoleAssignmentParameters(roleScope, roleAssignmentName);
            return this.clientImpl.getRoleAssignments().getWithResponseAsync(this.vaultUrl, roleScope.toString(), roleAssignmentName, context).doOnRequest(ignored -> LOGGER.verbose("Retrieving role assignment - {}", new Object[]{roleAssignmentName})).doOnSuccess(response -> LOGGER.verbose("Retrieved role assignment - {}", new Object[]{((RoleAssignment)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to retrieve role assignment - {}", new Object[]{roleAssignmentName, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAdministrationUtil::transformRoleAssignmentResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return this.deleteRoleAssignmentWithResponse(roleScope, roleAssignmentName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return FluxUtil.withContext(context -> this.deleteRoleAssignmentWithResponse(roleScope, roleAssignmentName, (Context)context));
    }

    Mono<Response<Void>> deleteRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        try {
            KeyVaultAdministrationUtil.validateRoleAssignmentParameters(roleScope, roleAssignmentName);
            return this.clientImpl.getRoleAssignments().deleteWithResponseAsync(this.vaultUrl, roleScope.toString(), roleAssignmentName, context).doOnRequest(ignored -> LOGGER.verbose("Deleting role assignment - {}", new Object[]{roleAssignmentName})).doOnSuccess(response -> LOGGER.verbose("Deleted role assignment - {}", new Object[]{((RoleAssignment)response.getValue()).getName()})).doOnError(error -> LOGGER.warning("Failed to delete role assignment - {}", new Object[]{roleAssignmentName, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> new SimpleResponse(response, null)).onErrorResume(KeyVaultAdministrationException.class, e -> KeyVaultAdministrationUtil.swallowExceptionForStatusCodeAsync(404, e, LOGGER));
        }
        catch (RuntimeException e2) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)e2);
        }
    }
}

