/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.administration.implementation.models.FullBackupOperation;
import com.azure.security.keyvault.administration.implementation.models.FullBackupResponse;
import com.azure.security.keyvault.administration.implementation.models.FullRestoreOperationResponse;
import com.azure.security.keyvault.administration.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.administration.implementation.models.RestoreOperation;
import com.azure.security.keyvault.administration.implementation.models.RestoreOperationParameters;
import com.azure.security.keyvault.administration.implementation.models.SASTokenParameter;
import com.azure.security.keyvault.administration.implementation.models.SelectiveKeyRestoreOperationParameters;
import com.azure.security.keyvault.administration.implementation.models.SelectiveKeyRestoreOperationResponse;
import reactor.core.publisher.Mono;

public final class KeyVaultBackupClientImpl {
    private final KeyVaultBackupClientService service;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    KeyVaultBackupClientImpl(String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    KeyVaultBackupClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    KeyVaultBackupClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.service = (KeyVaultBackupClientService)RestProxy.create(KeyVaultBackupClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FullBackupResponse> fullBackupWithResponseAsync(String vaultBaseUrl, SASTokenParameter azureStorageBlobContainerUri, Context context) {
        String accept = "application/json";
        return this.service.fullBackup(vaultBaseUrl, this.getApiVersion(), azureStorageBlobContainerUri, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FullBackupOperation>> fullBackupStatusWithResponseAsync(String vaultBaseUrl, String jobId, Context context) {
        String accept = "application/json";
        return this.service.fullBackupStatus(vaultBaseUrl, jobId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FullRestoreOperationResponse> fullRestoreOperationWithResponseAsync(String vaultBaseUrl, RestoreOperationParameters restoreBlobDetails, Context context) {
        String accept = "application/json";
        return this.service.fullRestoreOperation(vaultBaseUrl, this.getApiVersion(), restoreBlobDetails, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RestoreOperation>> restoreStatusWithResponseAsync(String vaultBaseUrl, String jobId, Context context) {
        String accept = "application/json";
        return this.service.restoreStatus(vaultBaseUrl, jobId, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SelectiveKeyRestoreOperationResponse> selectiveKeyRestoreOperationWithResponseAsync(String vaultBaseUrl, String keyName, SelectiveKeyRestoreOperationParameters restoreBlobDetails, Context context) {
        String accept = "application/json";
        return this.service.selectiveKeyRestoreOperation(vaultBaseUrl, keyName, this.getApiVersion(), restoreBlobDetails, "application/json", context);
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="KeyVaultBackupClient")
    public static interface KeyVaultBackupClientService {
        @Post(value="/backup")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<FullBackupResponse> fullBackup(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") SASTokenParameter var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/backup/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<FullBackupOperation>> fullBackupStatus(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="jobId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/restore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<FullRestoreOperationResponse> fullRestoreOperation(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") RestoreOperationParameters var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/restore/{jobId}/pending")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RestoreOperation>> restoreStatus(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="jobId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/keys/{keyName}/restore")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<SelectiveKeyRestoreOperationResponse> selectiveKeyRestoreOperation(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="keyName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SelectiveKeyRestoreOperationParameters var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

