/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.security.keyvault.administration.implementation.RoleAssignmentsImpl;
import com.azure.security.keyvault.administration.implementation.RoleDefinitionsImpl;

public final class KeyVaultAccessControlClientImpl {
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final RoleDefinitionsImpl roleDefinitions;
    private final RoleAssignmentsImpl roleAssignments;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public RoleDefinitionsImpl getRoleDefinitions() {
        return this.roleDefinitions;
    }

    public RoleAssignmentsImpl getRoleAssignments() {
        return this.roleAssignments;
    }

    KeyVaultAccessControlClientImpl(String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    KeyVaultAccessControlClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    KeyVaultAccessControlClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.roleDefinitions = new RoleDefinitionsImpl(this);
        this.roleAssignments = new RoleAssignmentsImpl(this);
    }
}

