/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.security.keyvault.administration.KeyVaultAccessControlAsyncClient;
import com.azure.security.keyvault.administration.KeyVaultAccessControlClientBuilder;
import com.azure.security.keyvault.administration.models.KeyVaultRoleAssignment;
import com.azure.security.keyvault.administration.models.KeyVaultRoleDefinition;
import com.azure.security.keyvault.administration.models.KeyVaultRoleScope;
import com.azure.security.keyvault.administration.models.SetRoleDefinitionOptions;
import java.util.UUID;

@ServiceClient(builder=KeyVaultAccessControlClientBuilder.class)
public final class KeyVaultAccessControlClient {
    private final KeyVaultAccessControlAsyncClient asyncClient;

    KeyVaultAccessControlClient(KeyVaultAccessControlAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public String getVaultUrl() {
        return this.asyncClient.getVaultUrl();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleDefinition> listRoleDefinitions(KeyVaultRoleScope roleScope) {
        return new PagedIterable(this.asyncClient.listRoleDefinitions(roleScope, Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleDefinition> listRoleDefinitions(KeyVaultRoleScope roleScope, Context context) {
        return new PagedIterable(this.asyncClient.listRoleDefinitions(roleScope, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleDefinition setRoleDefinition(KeyVaultRoleScope roleScope) {
        return (KeyVaultRoleDefinition)this.asyncClient.setRoleDefinition(roleScope).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleDefinition setRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return (KeyVaultRoleDefinition)this.asyncClient.setRoleDefinition(roleScope, roleDefinitionName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleDefinition> setRoleDefinitionWithResponse(SetRoleDefinitionOptions options, Context context) {
        return (Response)this.asyncClient.setRoleDefinitionWithResponse(options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleDefinition getRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return (KeyVaultRoleDefinition)this.asyncClient.getRoleDefinition(roleScope, roleDefinitionName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleDefinition> getRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        return (Response)this.asyncClient.getRoleDefinitionWithResponse(roleScope, roleDefinitionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        this.asyncClient.deleteRoleDefinition(roleScope, roleDefinitionName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        return (Response)this.asyncClient.deleteRoleDefinitionWithResponse(roleScope, roleDefinitionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleAssignment> listRoleAssignments(KeyVaultRoleScope roleScope) {
        return new PagedIterable(this.asyncClient.listRoleAssignments(roleScope, Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyVaultRoleAssignment> listRoleAssignments(KeyVaultRoleScope roleScope, Context context) {
        return new PagedIterable(this.asyncClient.listRoleAssignments(roleScope, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleAssignment createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId) {
        return (KeyVaultRoleAssignment)this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, UUID.randomUUID().toString(), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleAssignment createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName) {
        return (KeyVaultRoleAssignment)this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, roleAssignmentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleAssignment> createRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName, Context context) {
        return (Response)this.asyncClient.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, roleAssignmentName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultRoleAssignment getRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return (KeyVaultRoleAssignment)this.getRoleAssignmentWithResponse(roleScope, roleAssignmentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultRoleAssignment> getRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        return (Response)this.asyncClient.getRoleAssignmentWithResponse(roleScope, roleAssignmentName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        this.asyncClient.deleteRoleAssignment(roleScope, roleAssignmentName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        return (Response)this.asyncClient.deleteRoleAssignmentWithResponse(roleScope, roleAssignmentName, context).block();
    }
}

