/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.administration.KeyVaultAccessControlClientBuilder;
import com.azure.security.keyvault.administration.KeyVaultAdministrationServiceVersion;
import com.azure.security.keyvault.administration.implementation.KeyVaultAccessControlClientImpl;
import com.azure.security.keyvault.administration.implementation.KeyVaultAccessControlClientImplBuilder;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationUtils;
import com.azure.security.keyvault.administration.implementation.KeyVaultErrorCodeStrings;
import com.azure.security.keyvault.administration.implementation.models.DataAction;
import com.azure.security.keyvault.administration.implementation.models.Permission;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignment;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentCreateParameters;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentProperties;
import com.azure.security.keyvault.administration.implementation.models.RoleAssignmentPropertiesWithScope;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinition;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinitionCreateParameters;
import com.azure.security.keyvault.administration.implementation.models.RoleDefinitionProperties;
import com.azure.security.keyvault.administration.implementation.models.RoleScope;
import com.azure.security.keyvault.administration.models.KeyVaultAdministrationException;
import com.azure.security.keyvault.administration.models.KeyVaultDataAction;
import com.azure.security.keyvault.administration.models.KeyVaultPermission;
import com.azure.security.keyvault.administration.models.KeyVaultRoleAssignment;
import com.azure.security.keyvault.administration.models.KeyVaultRoleAssignmentProperties;
import com.azure.security.keyvault.administration.models.KeyVaultRoleDefinition;
import com.azure.security.keyvault.administration.models.KeyVaultRoleDefinitionType;
import com.azure.security.keyvault.administration.models.KeyVaultRoleScope;
import com.azure.security.keyvault.administration.models.KeyVaultRoleType;
import com.azure.security.keyvault.administration.models.SetRoleDefinitionOptions;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=KeyVaultAccessControlClientBuilder.class, isAsync=true)
public final class KeyVaultAccessControlAsyncClient {
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private final ClientLogger logger = new ClientLogger(KeyVaultAccessControlAsyncClient.class);
    private final KeyVaultAccessControlClientImpl clientImpl;
    private final String vaultUrl;
    private final String serviceVersion;
    private final HttpPipeline pipeline;

    KeyVaultAccessControlAsyncClient(URL vaultUrl, HttpPipeline httpPipeline, KeyVaultAdministrationServiceVersion serviceVersion) {
        Objects.requireNonNull(vaultUrl, KeyVaultErrorCodeStrings.getErrorString("vault_endpoint_required"));
        this.vaultUrl = vaultUrl.toString();
        this.serviceVersion = serviceVersion.getVersion();
        this.pipeline = httpPipeline;
        this.clientImpl = new KeyVaultAccessControlClientImplBuilder().pipeline(httpPipeline).apiVersion(this.serviceVersion).buildClient();
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyVaultRoleDefinition> listRoleDefinitions(KeyVaultRoleScope roleScope) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listRoleDefinitionsFirstPage(this.vaultUrl, roleScope, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listRoleDefinitionsNextPage((String)continuationToken, (Context)context)));
    }

    PagedFlux<KeyVaultRoleDefinition> listRoleDefinitions(KeyVaultRoleScope roleScope, Context context) {
        return new PagedFlux(() -> this.listRoleDefinitionsFirstPage(this.vaultUrl, roleScope, context), continuationToken -> this.listRoleDefinitionsNextPage((String)continuationToken, context));
    }

    Mono<PagedResponse<KeyVaultRoleDefinition>> listRoleDefinitionsFirstPage(String vaultUrl, KeyVaultRoleScope roleScope, Context context) {
        try {
            Objects.requireNonNull(roleScope, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleScope'"));
            return this.clientImpl.getRoleDefinitions().listSinglePageAsync(vaultUrl, roleScope.toString(), null, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing role definitions for roleScope - {}", new Object[]{roleScope})).doOnSuccess(response -> this.logger.verbose("Listed role definitions for roleScope - {}", new Object[]{roleScope})).doOnError(error -> this.logger.warning("Failed to list role definitions for roleScope - {}", new Object[]{roleScope, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAccessControlAsyncClient::transformRoleDefinitionsPagedResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<KeyVaultRoleDefinition>> listRoleDefinitionsNextPage(String continuationToken, Context context) {
        try {
            return this.clientImpl.getRoleDefinitions().listNextSinglePageAsync(continuationToken, this.vaultUrl, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next role definitions page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next role definitions page - Page {}", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next role definitions page - Page {}", new Object[]{continuationToken, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAccessControlAsyncClient::transformRoleDefinitionsPagedResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleDefinition> setRoleDefinition(KeyVaultRoleScope roleScope) {
        return this.setRoleDefinition(roleScope, UUID.randomUUID().toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleDefinition> setRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return this.setRoleDefinitionWithResponse(new SetRoleDefinitionOptions(roleScope, roleDefinitionName)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleDefinition>> setRoleDefinitionWithResponse(SetRoleDefinitionOptions options) {
        return FluxUtil.withContext(context -> this.setRoleDefinitionWithResponse(options, (Context)context));
    }

    Mono<Response<KeyVaultRoleDefinition>> setRoleDefinitionWithResponse(SetRoleDefinitionOptions options, Context context) {
        try {
            Objects.requireNonNull(options, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'options'"));
            Objects.requireNonNull(options.getRoleScope(), String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'options.getRoleScope()'"));
            Objects.requireNonNull(options.getRoleDefinitionName(), String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'options.getRoleDefinitionName()'"));
            List<RoleScope> assignableScopes = null;
            if (options.getAssignableScopes() != null) {
                assignableScopes = options.getAssignableScopes().stream().map(keyVaultRoleScope -> RoleScope.fromString(keyVaultRoleScope.toString())).collect(Collectors.toList());
            }
            List<Permission> permissions = null;
            if (options.getPermissions() != null) {
                permissions = options.getPermissions().stream().map(keyVaultPermission -> new Permission().setActions(keyVaultPermission.getActions()).setNotActions(keyVaultPermission.getNotActions()).setDataActions(keyVaultPermission.getDataActions().stream().map(allowedDataAction -> DataAction.fromString(allowedDataAction.toString())).collect(Collectors.toList())).setNotDataActions(keyVaultPermission.getNotDataActions().stream().map(notDataAction -> DataAction.fromString(notDataAction.toString())).collect(Collectors.toList()))).collect(Collectors.toList());
            }
            RoleDefinitionProperties roleDefinitionProperties = new RoleDefinitionProperties().setRoleName(options.getRoleDefinitionName()).setAssignableScopes(assignableScopes).setDescription(options.getDescription()).setPermissions(permissions);
            RoleDefinitionCreateParameters parameters = new RoleDefinitionCreateParameters().setProperties(roleDefinitionProperties);
            return this.clientImpl.getRoleDefinitions().createOrUpdateWithResponseAsync(this.vaultUrl, options.getRoleScope().toString(), options.getRoleDefinitionName(), parameters, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating role definition - {}", new Object[]{options.getRoleDefinitionName()})).doOnSuccess(response -> this.logger.verbose("Created role definition - {}", new Object[]{((RoleDefinition)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create role definition - {}", new Object[]{options.getRoleDefinitionName(), error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAccessControlAsyncClient::transformRoleDefinitionResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleDefinition> getRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return this.getRoleDefinitionWithResponse(roleScope, roleDefinitionName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleDefinition>> getRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return FluxUtil.withContext(context -> this.getRoleDefinitionWithResponse(roleScope, roleDefinitionName, (Context)context));
    }

    Mono<Response<KeyVaultRoleDefinition>> getRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        try {
            Objects.requireNonNull(roleScope, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleScope'"));
            Objects.requireNonNull(roleDefinitionName, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleDefinitionName'"));
            return this.clientImpl.getRoleDefinitions().getWithResponseAsync(this.vaultUrl, roleScope.toString(), roleDefinitionName, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving role definition - {}", new Object[]{roleDefinitionName})).doOnSuccess(response -> this.logger.verbose("Retrieved role definition - {}", new Object[]{((RoleDefinition)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to retrieved role definition - {}", new Object[]{roleDefinitionName, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAccessControlAsyncClient::transformRoleDefinitionResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRoleDefinition(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return this.deleteRoleDefinitionWithResponse(roleScope, roleDefinitionName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName) {
        return FluxUtil.withContext(context -> this.deleteRoleDefinitionWithResponse(roleScope, roleDefinitionName, (Context)context));
    }

    Mono<Response<Void>> deleteRoleDefinitionWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionName, Context context) {
        try {
            Objects.requireNonNull(roleScope, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleScope'"));
            Objects.requireNonNull(roleDefinitionName, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleDefinitionName'"));
            return this.clientImpl.getRoleDefinitions().deleteWithResponseAsync(this.vaultUrl, roleScope.toString(), roleDefinitionName, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Deleting role definition - {}", new Object[]{roleDefinitionName})).doOnSuccess(response -> this.logger.verbose("Deleted role definition - {}", new Object[]{((RoleDefinition)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to delete role definition - {}", new Object[]{roleDefinitionName, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> new SimpleResponse(response, null)).onErrorResume(KeyVaultAdministrationException.class, e -> KeyVaultAccessControlAsyncClient.swallowExceptionForStatusCode(404, e, this.logger));
        }
        catch (RuntimeException e2) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e2);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyVaultRoleAssignment> listRoleAssignments(KeyVaultRoleScope roleScope) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listRoleAssignmentsFirstPage(this.vaultUrl, roleScope, (Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listRoleAssignmentsNextPage((String)continuationToken, (Context)context)));
    }

    PagedFlux<KeyVaultRoleAssignment> listRoleAssignments(KeyVaultRoleScope roleScope, Context context) {
        return new PagedFlux(() -> this.listRoleAssignmentsFirstPage(this.vaultUrl, roleScope, context), continuationToken -> this.listRoleAssignmentsNextPage((String)continuationToken, context));
    }

    Mono<PagedResponse<KeyVaultRoleAssignment>> listRoleAssignmentsFirstPage(String vaultUrl, KeyVaultRoleScope roleScope, Context context) {
        try {
            Objects.requireNonNull(roleScope, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleScope'"));
            return this.clientImpl.getRoleAssignments().listForScopeSinglePageAsync(vaultUrl, roleScope.toString(), null, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing role assignments for roleScope - {}", new Object[]{roleScope})).doOnSuccess(response -> this.logger.verbose("Listed role assignments for roleScope - {}", new Object[]{roleScope})).doOnError(error -> this.logger.warning("Failed to list role assignments for roleScope - {}", new Object[]{roleScope, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAccessControlAsyncClient::transformRoleAssignmentsPagedResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<KeyVaultRoleAssignment>> listRoleAssignmentsNextPage(String continuationToken, Context context) {
        try {
            return this.clientImpl.getRoleAssignments().listForScopeNextSinglePageAsync(continuationToken, this.vaultUrl, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Listing next role assignments page - Page {}", new Object[]{continuationToken})).doOnSuccess(response -> this.logger.verbose("Listed next role assignments page - Page {}", new Object[]{continuationToken})).doOnError(error -> this.logger.warning("Failed to list next role assignments page - Page {}", new Object[]{continuationToken, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAccessControlAsyncClient::transformRoleAssignmentsPagedResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleAssignment> createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId) {
        return this.createRoleAssignment(roleScope, roleDefinitionId, principalId, UUID.randomUUID().toString());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleAssignment> createRoleAssignment(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName) {
        return this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, roleAssignmentName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleAssignment>> createRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName) {
        return FluxUtil.withContext(context -> this.createRoleAssignmentWithResponse(roleScope, roleDefinitionId, principalId, roleAssignmentName, (Context)context));
    }

    Mono<Response<KeyVaultRoleAssignment>> createRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleDefinitionId, String principalId, String roleAssignmentName, Context context) {
        try {
            Objects.requireNonNull(roleScope, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleScope'"));
            Objects.requireNonNull(roleAssignmentName, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleAssignmentName'"));
            Objects.requireNonNull(principalId, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'principalId'"));
            Objects.requireNonNull(roleDefinitionId, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleDefinitionId'"));
            RoleAssignmentProperties roleAssignmentProperties = new RoleAssignmentProperties().setRoleDefinitionId(roleDefinitionId).setPrincipalId(principalId);
            RoleAssignmentCreateParameters parameters = new RoleAssignmentCreateParameters().setProperties(roleAssignmentProperties);
            return this.clientImpl.getRoleAssignments().createWithResponseAsync(this.vaultUrl, roleScope.toString(), roleAssignmentName, parameters, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Creating role assignment - {}", new Object[]{roleAssignmentName})).doOnSuccess(response -> this.logger.verbose("Created role assignment - {}", new Object[]{((RoleAssignment)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to create role assignment - {}", new Object[]{roleAssignmentName, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAccessControlAsyncClient::transformRoleAssignmentResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVaultRoleAssignment> getRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return this.getRoleAssignmentWithResponse(roleScope, roleAssignmentName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVaultRoleAssignment>> getRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return FluxUtil.withContext(context -> this.getRoleAssignmentWithResponse(roleScope, roleAssignmentName, (Context)context));
    }

    Mono<Response<KeyVaultRoleAssignment>> getRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        try {
            Objects.requireNonNull(roleScope, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleScope'"));
            Objects.requireNonNull(roleAssignmentName, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleAssignmentName'"));
            return this.clientImpl.getRoleAssignments().getWithResponseAsync(this.vaultUrl, roleScope.toString(), roleAssignmentName, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Retrieving role assignment - {}", new Object[]{roleAssignmentName})).doOnSuccess(response -> this.logger.verbose("Retrieved role assignment - {}", new Object[]{((RoleAssignment)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to retrieve role assignment - {}", new Object[]{roleAssignmentName, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(KeyVaultAccessControlAsyncClient::transformRoleAssignmentResponse);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRoleAssignment(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return this.deleteRoleAssignmentWithResponse(roleScope, roleAssignmentName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName) {
        return FluxUtil.withContext(context -> this.deleteRoleAssignmentWithResponse(roleScope, roleAssignmentName, (Context)context));
    }

    Mono<Response<Void>> deleteRoleAssignmentWithResponse(KeyVaultRoleScope roleScope, String roleAssignmentName, Context context) {
        try {
            Objects.requireNonNull(roleScope, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleScope'"));
            Objects.requireNonNull(roleAssignmentName, String.format(KeyVaultErrorCodeStrings.getErrorString("parameter_required"), "'roleAssignmentName'"));
            return this.clientImpl.getRoleAssignments().deleteWithResponseAsync(this.vaultUrl, roleScope.toString(), roleAssignmentName, context.addData((Object)"az.namespace", (Object)KEYVAULT_TRACING_NAMESPACE_VALUE)).doOnRequest(ignored -> this.logger.verbose("Deleting role assignment - {}", new Object[]{roleAssignmentName})).doOnSuccess(response -> this.logger.verbose("Deleted role assignment - {}", new Object[]{((RoleAssignment)response.getValue()).getName()})).doOnError(error -> this.logger.warning("Failed to delete role assignment - {}", new Object[]{roleAssignmentName, error})).onErrorMap(KeyVaultAdministrationUtils::mapThrowableToKeyVaultAdministrationException).map(response -> new SimpleResponse(response, null)).onErrorResume(KeyVaultAdministrationException.class, e -> KeyVaultAccessControlAsyncClient.swallowExceptionForStatusCode(404, e, this.logger));
        }
        catch (RuntimeException e2) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e2);
        }
    }

    private static PagedResponse<KeyVaultRoleDefinition> transformRoleDefinitionsPagedResponse(PagedResponse<RoleDefinition> pagedResponse) {
        ArrayList<KeyVaultRoleDefinition> keyVaultRoleDefinitions = new ArrayList<KeyVaultRoleDefinition>();
        for (RoleDefinition roleDefinition : pagedResponse.getValue()) {
            keyVaultRoleDefinitions.add(KeyVaultAccessControlAsyncClient.roleDefinitionToKeyVaultRoleDefinition(roleDefinition));
        }
        return new TransformedPagedResponse(keyVaultRoleDefinitions, pagedResponse);
    }

    private static Response<KeyVaultRoleDefinition> transformRoleDefinitionResponse(Response<RoleDefinition> response) {
        KeyVaultRoleDefinition keyVaultRoleDefinition = KeyVaultAccessControlAsyncClient.roleDefinitionToKeyVaultRoleDefinition((RoleDefinition)response.getValue());
        return new TransformedResponse<KeyVaultRoleDefinition, RoleDefinition>(keyVaultRoleDefinition, response);
    }

    private static KeyVaultRoleDefinition roleDefinitionToKeyVaultRoleDefinition(RoleDefinition roleDefinition) {
        ArrayList<KeyVaultPermission> keyVaultPermissions = new ArrayList<KeyVaultPermission>();
        for (Permission permission : roleDefinition.getPermissions()) {
            keyVaultPermissions.add(new KeyVaultPermission(permission.getActions(), permission.getNotActions(), permission.getDataActions().stream().map(dataAction -> KeyVaultDataAction.fromString(dataAction.toString())).collect(Collectors.toList()), permission.getNotDataActions().stream().map(notDataAction -> KeyVaultDataAction.fromString(notDataAction.toString())).collect(Collectors.toList())));
        }
        return new KeyVaultRoleDefinition(roleDefinition.getId(), roleDefinition.getName(), KeyVaultRoleDefinitionType.fromString(roleDefinition.getType().toString()), roleDefinition.getRoleName(), roleDefinition.getDescription(), KeyVaultRoleType.fromString(roleDefinition.getRoleType().toString()), keyVaultPermissions, roleDefinition.getAssignableScopes().stream().map(roleScope -> KeyVaultRoleScope.fromString(roleScope.toString())).collect(Collectors.toList()));
    }

    private static PagedResponse<KeyVaultRoleAssignment> transformRoleAssignmentsPagedResponse(PagedResponse<RoleAssignment> pagedResponse) {
        ArrayList<KeyVaultRoleAssignment> keyVaultRoleAssignments = new ArrayList<KeyVaultRoleAssignment>();
        for (RoleAssignment roleAssignment : pagedResponse.getValue()) {
            keyVaultRoleAssignments.add(KeyVaultAccessControlAsyncClient.roleAssignmentToKeyVaultRoleAssignment(roleAssignment));
        }
        return new TransformedPagedResponse(keyVaultRoleAssignments, pagedResponse);
    }

    private static Response<KeyVaultRoleAssignment> transformRoleAssignmentResponse(Response<RoleAssignment> response) {
        KeyVaultRoleAssignment keyVaultRoleAssignment = KeyVaultAccessControlAsyncClient.roleAssignmentToKeyVaultRoleAssignment((RoleAssignment)response.getValue());
        return new TransformedResponse<KeyVaultRoleAssignment, RoleAssignment>(keyVaultRoleAssignment, response);
    }

    private static KeyVaultRoleAssignment roleAssignmentToKeyVaultRoleAssignment(RoleAssignment roleAssignment) {
        RoleAssignmentPropertiesWithScope propertiesWithScope = roleAssignment.getProperties();
        return new KeyVaultRoleAssignment(roleAssignment.getId(), roleAssignment.getName(), roleAssignment.getType(), new KeyVaultRoleAssignmentProperties(propertiesWithScope.getRoleDefinitionId(), propertiesWithScope.getPrincipalId(), KeyVaultRoleScope.fromString(propertiesWithScope.getScope().toString())));
    }

    static <E extends HttpResponseException> Mono<Response<Void>> swallowExceptionForStatusCode(int statusCode, E httpResponseException, ClientLogger logger) {
        HttpResponse httpResponse = httpResponseException.getResponse();
        if (httpResponse.getStatusCode() == statusCode) {
            return Mono.just((Object)new SimpleResponse(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null));
        }
        return FluxUtil.monoError((ClientLogger)logger, httpResponseException);
    }

    private static final class TransformedResponse<T, U>
    implements Response<T> {
        private final T output;
        private final Response<U> response;

        TransformedResponse(T output, Response<U> response) {
            this.output = output;
            this.response = response;
        }

        public int getStatusCode() {
            return this.response.getStatusCode();
        }

        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }

        public HttpRequest getRequest() {
            return this.response.getRequest();
        }

        public T getValue() {
            return this.output;
        }
    }

    private static final class TransformedPagedResponse<L extends List<T>, T, U>
    implements PagedResponse<T> {
        private final L output;
        private final PagedResponse<U> pagedResponse;

        TransformedPagedResponse(L output, PagedResponse<U> inputPagedResponse) {
            this.output = output;
            this.pagedResponse = inputPagedResponse;
        }

        public void close() throws IOException {
        }

        public IterableStream<T> getElements() {
            return new IterableStream(this.output);
        }

        public String getContinuationToken() {
            return (String)this.pagedResponse.getContinuationToken();
        }

        public int getStatusCode() {
            return this.pagedResponse.getStatusCode();
        }

        public HttpHeaders getHeaders() {
            return this.pagedResponse.getHeaders();
        }

        public HttpRequest getRequest() {
            return this.pagedResponse.getRequest();
        }

        public List<T> getValue() {
            return this.output;
        }
    }
}

