/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.models.VectorQuery;
import com.azure.search.documents.models.VectorQueryKind;
import java.io.IOException;

public final class VectorizableTextQuery
extends VectorQuery {
    private VectorQueryKind kind = VectorQueryKind.TEXT;
    private final String text;

    public VectorizableTextQuery(String text) {
        this.text = text;
    }

    @Override
    public VectorQueryKind getKind() {
        return this.kind;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public VectorizableTextQuery setKNearestNeighborsCount(Integer kNearestNeighborsCount) {
        super.setKNearestNeighborsCount(kNearestNeighborsCount);
        return this;
    }

    @Override
    public VectorizableTextQuery setFields(String ... fields) {
        super.setFields(fields);
        return this;
    }

    @Override
    public VectorizableTextQuery setExhaustive(Boolean exhaustive) {
        super.setExhaustive(exhaustive);
        return this;
    }

    @Override
    public VectorizableTextQuery setOversampling(Double oversampling) {
        super.setOversampling(oversampling);
        return this;
    }

    @Override
    public VectorizableTextQuery setWeight(Float weight) {
        super.setWeight(weight);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("k", (Number)this.getKNearestNeighborsCount());
        jsonWriter.writeStringField("fields", this.getFields());
        jsonWriter.writeBooleanField("exhaustive", this.isExhaustive());
        jsonWriter.writeNumberField("oversampling", (Number)this.getOversampling());
        jsonWriter.writeNumberField("weight", (Number)this.getWeight());
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static VectorizableTextQuery fromJson(JsonReader jsonReader) throws IOException {
        return (VectorizableTextQuery)jsonReader.readObject(reader -> {
            Integer kNearestNeighborsCount = null;
            String fields = null;
            Boolean exhaustive = null;
            Double oversampling = null;
            Float weight = null;
            boolean textFound = false;
            String text = null;
            VectorQueryKind kind = VectorQueryKind.TEXT;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("k".equals(fieldName)) {
                    kNearestNeighborsCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    fields = reader.getString();
                    continue;
                }
                if ("exhaustive".equals(fieldName)) {
                    exhaustive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("oversampling".equals(fieldName)) {
                    oversampling = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    weight = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    textFound = true;
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = VectorQueryKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (textFound) {
                VectorizableTextQuery deserializedVectorizableTextQuery = new VectorizableTextQuery(text);
                deserializedVectorizableTextQuery.setKNearestNeighborsCount(kNearestNeighborsCount);
                deserializedVectorizableTextQuery.setFields(fields);
                deserializedVectorizableTextQuery.setExhaustive(exhaustive);
                deserializedVectorizableTextQuery.setOversampling(oversampling);
                deserializedVectorizableTextQuery.setWeight(weight);
                deserializedVectorizableTextQuery.kind = kind;
                return deserializedVectorizableTextQuery;
            }
            throw new IllegalStateException("Missing required property: text");
        });
    }
}

