/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchIndexerDataIdentity;
import java.io.IOException;

public final class SearchIndexerDataUserAssignedIdentity
extends SearchIndexerDataIdentity {
    private String odataType = "#Microsoft.Azure.Search.DataUserAssignedIdentity";
    private final String resourceId;

    public SearchIndexerDataUserAssignedIdentity(String resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    public String getOdataType() {
        return this.odataType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userAssignedIdentity", this.resourceId);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    public static SearchIndexerDataUserAssignedIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (SearchIndexerDataUserAssignedIdentity)jsonReader.readObject(reader -> {
            boolean resourceIdFound = false;
            String resourceId = null;
            String odataType = "#Microsoft.Azure.Search.DataUserAssignedIdentity";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userAssignedIdentity".equals(fieldName)) {
                    resourceId = reader.getString();
                    resourceIdFound = true;
                    continue;
                }
                if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (resourceIdFound) {
                SearchIndexerDataUserAssignedIdentity deserializedSearchIndexerDataUserAssignedIdentity = new SearchIndexerDataUserAssignedIdentity(resourceId);
                deserializedSearchIndexerDataUserAssignedIdentity.odataType = odataType;
                return deserializedSearchIndexerDataUserAssignedIdentity;
            }
            throw new IllegalStateException("Missing required property: userAssignedIdentity");
        });
    }
}

