/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.DistanceScoringFunction;
import com.azure.search.documents.indexes.models.FreshnessScoringFunction;
import com.azure.search.documents.indexes.models.MagnitudeScoringFunction;
import com.azure.search.documents.indexes.models.ScoringFunctionInterpolation;
import com.azure.search.documents.indexes.models.TagScoringFunction;
import java.io.IOException;
import java.util.ArrayList;

public class ScoringFunction
implements JsonSerializable<ScoringFunction> {
    private String type = "ScoringFunction";
    private final String fieldName;
    private final double boost;
    private ScoringFunctionInterpolation interpolation;

    public ScoringFunction(String fieldName, double boost) {
        this.fieldName = fieldName;
        this.boost = boost;
    }

    public String getType() {
        return this.type;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public double getBoost() {
        return this.boost;
    }

    public ScoringFunctionInterpolation getInterpolation() {
        return this.interpolation;
    }

    public ScoringFunction setInterpolation(ScoringFunctionInterpolation interpolation) {
        this.interpolation = interpolation;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fieldName", this.fieldName);
        jsonWriter.writeDoubleField("boost", this.boost);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("interpolation", this.interpolation == null ? null : this.interpolation.toString());
        return jsonWriter.writeEndObject();
    }

    public static ScoringFunction fromJson(JsonReader jsonReader) throws IOException {
        return (ScoringFunction)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ScoringFunction scoringFunction;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String jsonFieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(jsonFieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("distance".equals(discriminatorValue)) {
                    scoringFunction = DistanceScoringFunction.fromJson(readerToUse.reset());
                    return scoringFunction;
                }
                if ("freshness".equals(discriminatorValue)) {
                    scoringFunction = FreshnessScoringFunction.fromJson(readerToUse.reset());
                    return scoringFunction;
                }
                if ("magnitude".equals(discriminatorValue)) {
                    scoringFunction = MagnitudeScoringFunction.fromJson(readerToUse.reset());
                    return scoringFunction;
                }
                if ("tag".equals(discriminatorValue)) {
                    scoringFunction = TagScoringFunction.fromJson(readerToUse.reset());
                    return scoringFunction;
                }
                scoringFunction = ScoringFunction.fromJsonKnownDiscriminator(readerToUse.reset());
                return scoringFunction;
            }
        });
    }

    static ScoringFunction fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ScoringFunction)jsonReader.readObject(reader -> {
            boolean fieldNameFound = false;
            String fieldName = null;
            boolean boostFound = false;
            double boost = 0.0;
            String type = null;
            ScoringFunctionInterpolation interpolation = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String jsonFieldName = reader.getFieldName();
                reader.nextToken();
                if ("fieldName".equals(jsonFieldName)) {
                    fieldName = reader.getString();
                    fieldNameFound = true;
                    continue;
                }
                if ("boost".equals(jsonFieldName)) {
                    boost = reader.getDouble();
                    boostFound = true;
                    continue;
                }
                if ("type".equals(jsonFieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("interpolation".equals(jsonFieldName)) {
                    interpolation = ScoringFunctionInterpolation.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (fieldNameFound && boostFound) {
                ScoringFunction deserializedScoringFunction = new ScoringFunction(fieldName, boost);
                deserializedScoringFunction.type = type;
                deserializedScoringFunction.interpolation = interpolation;
                return deserializedScoringFunction;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!fieldNameFound) {
                missingProperties.add("fieldName");
            }
            if (!boostFound) {
                missingProperties.add("boost");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

