/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.FieldMappingFunction;
import java.io.IOException;

public final class FieldMapping
implements JsonSerializable<FieldMapping> {
    private final String sourceFieldName;
    private String targetFieldName;
    private FieldMappingFunction mappingFunction;

    public FieldMapping(String sourceFieldName) {
        this.sourceFieldName = sourceFieldName;
    }

    public String getSourceFieldName() {
        return this.sourceFieldName;
    }

    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    public FieldMapping setTargetFieldName(String targetFieldName) {
        this.targetFieldName = targetFieldName;
        return this;
    }

    public FieldMappingFunction getMappingFunction() {
        return this.mappingFunction;
    }

    public FieldMapping setMappingFunction(FieldMappingFunction mappingFunction) {
        this.mappingFunction = mappingFunction;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceFieldName", this.sourceFieldName);
        jsonWriter.writeStringField("targetFieldName", this.targetFieldName);
        jsonWriter.writeJsonField("mappingFunction", (JsonSerializable)this.mappingFunction);
        return jsonWriter.writeEndObject();
    }

    public static FieldMapping fromJson(JsonReader jsonReader) throws IOException {
        return (FieldMapping)jsonReader.readObject(reader -> {
            boolean sourceFieldNameFound = false;
            String sourceFieldName = null;
            String targetFieldName = null;
            FieldMappingFunction mappingFunction = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceFieldName".equals(fieldName)) {
                    sourceFieldName = reader.getString();
                    sourceFieldNameFound = true;
                    continue;
                }
                if ("targetFieldName".equals(fieldName)) {
                    targetFieldName = reader.getString();
                    continue;
                }
                if ("mappingFunction".equals(fieldName)) {
                    mappingFunction = FieldMappingFunction.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            if (sourceFieldNameFound) {
                FieldMapping deserializedFieldMapping = new FieldMapping(sourceFieldName);
                deserializedFieldMapping.targetFieldName = targetFieldName;
                deserializedFieldMapping.mappingFunction = mappingFunction;
                return deserializedFieldMapping;
            }
            throw new IllegalStateException("Missing required property: sourceFieldName");
        });
    }
}

