/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.EdgeNGramTokenFilterV1;
import com.azure.search.documents.indexes.implementation.models.EdgeNGramTokenFilterV2;
import com.azure.search.documents.indexes.models.EdgeNGramTokenFilterSide;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;

public final class EdgeNGramTokenFilter
extends TokenFilter {
    private final EdgeNGramTokenFilterV1 v1Filter;
    private final EdgeNGramTokenFilterV2 v2Filter;

    EdgeNGramTokenFilter(EdgeNGramTokenFilterV1 v1Filter) {
        super(v1Filter.getName());
        this.v1Filter = v1Filter;
        this.v2Filter = null;
    }

    EdgeNGramTokenFilter(EdgeNGramTokenFilterV2 v2Filter) {
        super(v2Filter.getName());
        this.v1Filter = null;
        this.v2Filter = v2Filter;
    }

    public EdgeNGramTokenFilter(String name) {
        super(name);
        this.v1Filter = null;
        this.v2Filter = new EdgeNGramTokenFilterV2(name);
    }

    public Integer getMinGram() {
        return this.v1Filter != null ? this.v1Filter.getMinGram() : this.v2Filter.getMinGram();
    }

    public EdgeNGramTokenFilter setMinGram(Integer minGram) {
        if (this.v1Filter != null) {
            this.v1Filter.setMinGram(minGram);
        } else {
            this.v2Filter.setMinGram(minGram);
        }
        return this;
    }

    public Integer getMaxGram() {
        return this.v1Filter != null ? this.v1Filter.getMaxGram() : this.v2Filter.getMaxGram();
    }

    public EdgeNGramTokenFilter setMaxGram(Integer maxGram) {
        if (this.v1Filter != null) {
            this.v1Filter.setMaxGram(maxGram);
        } else {
            this.v2Filter.setMaxGram(maxGram);
        }
        return this;
    }

    public EdgeNGramTokenFilterSide getSide() {
        return this.v1Filter != null ? this.v1Filter.getSide() : this.v2Filter.getSide();
    }

    public EdgeNGramTokenFilter setSide(EdgeNGramTokenFilterSide side) {
        if (this.v1Filter != null) {
            this.v1Filter.setSide(side);
        } else {
            this.v2Filter.setSide(side);
        }
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return this.v1Filter != null ? this.v1Filter.toJson(jsonWriter) : this.v2Filter.toJson(jsonWriter);
    }
}

