/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.core.util.serializer.TypeReference;
import com.azure.search.documents.SearchDocument;
import com.azure.search.documents.implementation.util.Utility;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public final class SearchResult {
    private final ClientLogger logger = new ClientLogger(SearchResult.class);
    @JsonProperty(value="")
    private SearchDocument additionalProperties;
    @JsonProperty(value="@search.score", required=true, access=JsonProperty.Access.WRITE_ONLY)
    private double score;
    @JsonProperty(value="@search.highlights", access=JsonProperty.Access.WRITE_ONLY)
    private Map<String, List<String>> highlights;
    @JsonIgnore
    private JsonSerializer jsonSerializer;
    private static final JacksonAdapter searchJacksonAdapter = (JacksonAdapter)Utility.initializeSerializerAdapter();

    @JsonCreator
    public SearchResult(@JsonProperty(value="@search.score", required=true, access=JsonProperty.Access.WRITE_ONLY) double score) {
        this.score = score;
    }

    public <T> T getDocument(Class<T> modelClass) {
        if (this.jsonSerializer == null) {
            try {
                String serializedJson = searchJacksonAdapter.serialize((Object)this.additionalProperties, SerializerEncoding.JSON);
                return (T)searchJacksonAdapter.deserialize(serializedJson, modelClass, SerializerEncoding.JSON);
            }
            catch (IOException ex) {
                throw this.logger.logExceptionAsError(new RuntimeException("Something wrong with the serialization."));
            }
        }
        ByteArrayOutputStream sourceStream = new ByteArrayOutputStream();
        this.jsonSerializer.serialize((OutputStream)sourceStream, (Object)this.additionalProperties);
        return (T)this.jsonSerializer.deserialize((InputStream)new ByteArrayInputStream(sourceStream.toByteArray()), TypeReference.createInstance(modelClass));
    }

    public double getScore() {
        return this.score;
    }

    public Map<String, List<String>> getHighlights() {
        return this.highlights;
    }
}

